local function stringify (value)
   if type(value) == "string" then
      return "\"" .. value .. "\""
   elseif type(value) == "table" then
      for i, element in ipairs (value) do
	 value[i] = stringify(element) .. ", "
      end

      return "{" .. table.concat(value) .. "}"
   else
      return tostring(value)
   end
end

local function writeoptions ()
   local content = ""

   for _, option in pairs {"port"} do
      content = content .. "network." .. option .. " = " .. 
	        stringify(network[option]) .. "\n"
   end

   content = content .. "\n"

   for _, option in pairs {"window", "range", "field", "grabpointer",
			   "grabkeyboard", "canvas"} do
      content = content .. "graphics." .. option .. " = " ..
	        stringify(graphics[option]) .. "\n"
   end

   content = content .. "\n"

   for _, option in pairs {"stepsize", "iterations"} do
      content = content .. "simulator." .. option .. " = " ..
	        stringify(simulator[option]) .. "\n"
   end

   content = content .. "\n"

   for _, option in pairs {"players", "firstname", "secondname",
			   "cushion", "balkline", "straight",
			   "distance", "cushions", "balkspacing",
			   "crotchspacing", "anchorwidth", "anchorheight",
			   "allowedcounts", "tablewidth", "tableheight",
			   "cushionheight", "ballradius", "ballmass",
			   "cuemass", "cueinertia", "cueforce",
			   "cuelength", "slidingfriction", "rollingfriction",
			   "spinningfriction", "strikingfriction",
			   "slowfriction", "fastfriction", "bouncingfriction",
			   "collidingrestitution", "strikingrestitution",
			   "bouncingrestitution", "jumpingrestitution",
			   "linear", "angular", "stroke", "drawtrajectories",
			   "drawvectors", "drawcenterline", "drawsidelines",
			   "quit", "overhead", "ready", "replay", "undo",
			   "pause", "faster", "slower", "rotate", "zoom",
			   "strike", "elevate", "offset"} do
      content = content .. "billiards." .. option .. " = " ..
	        stringify(billiards[option]) .. "\n"
   end
   
   file = io.open (os.getenv ("HOME") .. "/.billiards", "w")

   if file then
      file:write (content)
      file:close ()
   end

   return nil
end

network.pages["/writeoptions"] = writeoptions
network.mime["/writeoptions"] = "text/html"


