-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local groups = {
   {
      name = 'gameprop',
      header = 'Game properties',
      rows = {
	 {'distance', 'Game distance', 
	  'The points required to win a game.'},
	 {'cushions', 'Cushions', 
	  'The number of cushions the cue ball has to touch before it '..
	     'meets the second object ball.'},
	 {'allowedcounts', 'Allowed counts', 
	  'The number of counts allowed within a balk space.'},
	 {'balkspacing', 'Balkline spacing', 
	  'The distance between the balk lines and the rails in meters.  ' ..
	     'Set this to zero to disable balklines altogether.'},
	 {'crotchspacing', 'Crotch spacing', 
	  'The length of the sides of the <q>crotch</q>.'},
	 {'anchorwidth', 'Anchor width', 
	  'The width of the anchor spaces.'},
	 {'anchorheight', 'Anchor height', 
	  'The height of the anchor spaces.'}
      }
   },

   {
      name = 'gearprop',
      header = 'Gear properties',
      rows = {
	 {'tablewidth', 'Table width',
	  'The width of the playing area in meters.'},
	 {'tableheight', 'Table height',
	  'The height of the playing area in meters.'},
	 {'cushionheight', 'Cushion height',
	  'The height of the cushions in meters at the ' ..  
	  'point where they contact the balls.'},
	 {'ballradius', 'Ball radius',
	  'The radius of the balls in meters.'},
	 {'ballmass', 'Ball mass',
	  'The weight of the balls in kilograms.'},
	 {'cuemass', 'Cue mass',
	  'The mass of the cue in kilograms.  Choose this ' ..
	  'according to the weight of your favorite cue.'},
	 {'cueinertia', 'Cue inertia',
	  'This is the effective moment of inertia of the cue ' ..
	  'tip around the vertical axis.  This value affects ' ..
	  'the initial deflection of the path of the cue ball due ' ..
	  'to left or right english, also known as the squirt effect.'},
	 {'cueforce', 'Cue force',
	  'The maximum force the player can exert while stroking ' ..
	  'the cue in Newtons.'}
      }
   },

   {
      name = 'restitution',
      header = 'Coefficients of restitution',
      rows = {
	 {'strikingrestitution', 'Striking restitution',
	  'The coefficient of restitution between the cue tip and ' ..
	     'the cue ball.'},
	 {'collidingrestitution', 'Colliding restitution',
	  'The coefficient of restitution between colliding balls.  ' ..
	     'This defines how efficiently the balls collide with each ' ..
	     'other and should usually be very close to 1.'},
	 {'bouncingrestitution', 'Bouncing restitution',
	  'The coefficient of restitution between balls and ' ..
	     'cushions.  Higher values result in more elastic and thus ' ..
	     'efficient cushions.'},
	 {'jumpingrestitution', 'Jumping restitution',
	  'The coefficient of restitution describing the elasticity ' ..
	     'of the table bed.  Large values make it easier for a ball ' ..
	     'to bounce off the table.'}
      }
      
   },

   {
      name = 'friction',
      header = 'Coefficients of friction',
      rows = {
	 {'slidingfriction', 'Sliding friction',
	  'The coefficient of sliding friction between the cloth ' ..
	     'and balls.  This determines how soon the ball begins to ' ..
	     'roll without slipping after it has been struck by the cue.'},
	 {'rollingfriction', 'Rolling friction',
	  'The coefficient of rolling friction between the cloth ' ..
	     'and balls.  The lower the value the longer do the balls ' ..
	     'roll before coming to a stop.  Divide 1 by this number ' ..
	     'to get the table speed.'},
	 {'spinningfriction', 'Spinning friction',
	  'The coefficient of spinning friction between the cloth ' ..
	     'and balls.  This determines the amount of friction ' ..
	     'present when the ball spins like a top around the ' ..
	     'vertical axis.  Larger values therefore tend to make the ' ..
	     'balls lose the vertical component of their rotation faster.'},
	 {'strikingfriction', 'Striking friction',
	  'The coefficient of friction between the cue stick and the ' ..
	     'cue ball.  This value determines how well the cue tip ' ..
	     'grips the cue ball and therefore how easy or difficult ' ..
	     'it is for you to miscue.  Large values correspond to a ' ..
	     'well chalked cue while smaller ones can be used to ' ..
	     'simulate a bad or worn cue.'},
	 {'bouncingfriction', 'Bouncing friction',
	  'The coefficient of sliding friction between the balls and ' ..
	     'the cushions.'},
	 {'slowfriction', 'Slow friction',
	  'The coefficient of sliding friction between two colliding ' ..
	     'balls.  This is the value used for <q>slow</q> collisions.'},
	 {'fastfriction', 'Fast friction',
	  'As in <q>Slow friction</q> above, but for <q>fast</q> ' ..
	     'collisions.'}
      }
   },

   {
      name = 'aids',
      header = 'Training aids',
      rows = {
	 {'drawtrajectories', 'Draw trajectories', 'Trace the trajectories ' ..
	  'of the balls.'},
	 {'drawvectors', 'Draw velocities', 'Draw each ball\'s  linear and' ..
	  'angular velocity vector.'},
	 {'drawcenterline', 'Draw centerline', 'Draw a line along the ' ..
	  'cue\'s line of sight.'},
	 {'drawsidelines', 'Draw sidelines', 'Draw two more lines from the ' ..
	  'edges of the cue ball and parallel to the ceneterline.'}
      }
   },
}

local function newgame (page, arguments)
   local content

   content = string.format([[
<head>

<title>New game</title>
<link rel="stylesheet" href="stylesheet">

<style type="text/css">
  col.first {width : 12em;}
  col.second {width : 7em ;}
</style>

</head>

<hr> 
<h1><iframe style="width : 8em ; height : 3em"
            frameborder="0" src="logo">Billiards
</iframe></h1>
<a href="javascript:document.forms[0].submit()">done</a>
&middot;
<a href="javascript:document.forms[0].reset()">reset</a>
&middot;
<a href = "/">cancel</a>
&middot;
<a href="#players">players</a>
&middot;
<a href="#gametype">game type</a>
&middot;
<a href="#gameprop">game properties</a>
&middot;
<a href="#gearprop">gear properties</a>
&middot;
<a href="#restitution">coefficients of restitution</a>
&middot;
<a href="#friction">coefficients of friction</a>
&middot;
<a href="#aids">training aids</a>
<hr> 

<p>Edit the following form and click done to start a new game.  Don't be intimidated by the large number of available options.  All you'll probably want to specify is the game type, participating players and game distance.  Still it's worth the while to take a look at the other options as well.  They allow you to customize most aspects of the game.  Also be sure to check out the training aids at the bottom of the form.  They can be a big help for beginners.

<form action="/" method="get">
<table>

<col class="first">
<col class="second">
<col class="third">

<tr><th colspan="3"><a name="gametype">Game type</a>
<tr class="odd">
<td colspan="2">
<div>
<input type="radio" name="players" value="1" %s>One-player game</input>
</div>
<div>
<input type="radio" name="players" value="2" %s>Two-player game</input>
</div>
<td>The number of players participating in the game.

<tr class="even">
<td colspan="2">
<div>
<input type="radio" name="game" value="cushion" %s>Cushion billiards</input>
</div>
<div>
<input type="radio" name="game" value="balkline" %s>Balkline billiards</input>
</div>
<div>
<input type="radio" name="game" value="straight" %s>Straight rail</input>
</div>
<td>The game discipline.

<tr><th colspan="3"><a name="players">Players</a>
<tr class="odd"><td>First player:
<td align="center"><input type="text" name="firstname" size="10" value="%s">
<td>The name of the first player.

<tr class="even"><td>Second player:
<td align="center"><input type="text" name="secondname" size="10" value="%s">
<td>The name of the second player.
   ]],
   billiards.players == 1 and "checked" or "",
   billiards.players == 2 and "checked" or "",
   billiards.cushion and "checked" or "",
   billiards.balkline and "checked" or "",
   billiards.straight and "checked" or "",
   billiards.firstname, billiards.secondname)

   for j, group in pairs(groups) do
      content = content .. string.format([[
<tr><th colspan="3"><a name="%s">%s</a>
				      ]], group.name, group.header)
   
      for i, row in ipairs (group.rows) do
	 local name, label, description = unpack (row)
	 local html

	 if group.header == 'Game properties' and i <= 3 then
	    html = string.format([[
<tr class="%s">
<td>%s:
<td align="center">
<input class="number" type="text" name="%s" value = "%d" size = "10"><td>%s
			      ]],
			      math.mod(i, 2) == 1 and "even" or "odd",
			      label, name, billiards[name], description)
	 elseif group.header == 'Training aids' then
	    html = string.format([[
<tr class="%s">
<td colspan="2">
<input class="number" type="checkbox" name="%s" value="true" %s>%s</input>
<td>%s
			      ]],
			      math.mod(i, 2) == 1 and "even" or "odd",
			      name, billiards[name] and "checked" or "",
			      label, description)
	 else
	    html = string.format([[
<tr class="%s">
<td>%s:
<td align="center">
<input class="number" type="text" name="%s" value = "%g" size = "10">
<td>%s
			      ]],
			      math.mod(i, 2) == 1 and "even" or "odd",
			      label, name, billiards[name], description)
	 end

	 content = content .. html
      end
   end

   return content .. [[
<input name="newgame" value="yes" type="hidden"/>
</table></form>
      ]]   
end

network.pages["/newgame"] = newgame
network.mime["/newgame"] = "text/html"
