package Bibulus::pl;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{pl}{and} ||= 'i';
  $self->{LANGTEXT}{pl}{etal} ||= 'et al.';
  $self->{LANGTEXT}{pl}{editors}{full} ||= 'redaktorzy';
  $self->{LANGTEXT}{pl}{editors}{abbr} ||= 'red.';
  $self->{LANGTEXT}{pl}{editor}{full} ||= 'redaktor';
  $self->{LANGTEXT}{pl}{editor}{abbr} ||= 'red.';
  $self->{LANGTEXT}{pl}{edby} ||= 'pod redakcją';
  $self->{LANGTEXT}{pl}{edition}{full} ||= 'wydanie';
  $self->{LANGTEXT}{pl}{edition}{abbr} ||= 'wyd.';
  $self->{LANGTEXT}{pl}{volume}{full} ||= 'tom';
  $self->{LANGTEXT}{pl}{volume}{abbr} ||= 'tom';
  $self->{LANGTEXT}{pl}{of} ||= 'z serii';
  $self->{LANGTEXT}{pl}{number}{full} ||= 'numer';
  $self->{LANGTEXT}{pl}{number}{abbr} ||= 'nr';
  $self->{LANGTEXT}{pl}{nr} ||= 'nr';
  $self->{LANGTEXT}{pl}{in} ||= 'w';
  $self->{LANGTEXT}{pl}{pages}{full} ||= 'strony';
  $self->{LANGTEXT}{pl}{pages}{abbr} ||= 'str.';
  $self->{LANGTEXT}{pl}{page}{full} ||= 'strona';
  $self->{LANGTEXT}{pl}{page}{abbr} ||= 'str.';
  $self->{LANGTEXT}{pl}{eidpp} ||= 'strony';
  $self->{LANGTEXT}{pl}{chapter}{full} ||= 'rozdział';
  $self->{LANGTEXT}{pl}{chapter}{abbr} ||= 'rozdz.';
  $self->{LANGTEXT}{pl}{techrep}{full} ||= 'Raport techniczny';
  $self->{LANGTEXT}{pl}{techrep}{abbr} ||= 'Rap. tech.';
  $self->{LANGTEXT}{pl}{mthesis} ||= 'Praca magisterska';
  $self->{LANGTEXT}{pl}{phdthesis} ||= 'Rozprawa doktorska';
  $self->{LANGTEXT}{pl}{edno}{1}{full} ||= 'pierwsze';
  $self->{LANGTEXT}{pl}{edno}{1}{abbr} ||= '1.';
  $self->{LANGTEXT}{pl}{edno}{2}{full} ||= 'drugie';
  $self->{LANGTEXT}{pl}{edno}{2}{abbr} ||= '2.';
  $self->{LANGTEXT}{pl}{edno}{3}{full} ||= 'trzecie';
  $self->{LANGTEXT}{pl}{edno}{3}{abbr} ||= '3.';
  $self->{LANGTEXT}{pl}{edno}{4}{full} ||= 'czwarte';
  $self->{LANGTEXT}{pl}{edno}{4}{abbr} ||= '4.';
  $self->{LANGTEXT}{pl}{edno}{5}{full} ||= 'piąte';
  $self->{LANGTEXT}{pl}{edno}{5}{abbr} ||= '5.';
  $self->{LANGTEXT}{pl}{st} ||= '.';
  $self->{LANGTEXT}{pl}{nd} ||= '.';
  $self->{LANGTEXT}{pl}{rd} ||= '.';
  $self->{LANGTEXT}{pl}{th} ||= '.';
  $self->{LANGTEXT}{pl}{month1}{full} ||= 'styczeń';
  $self->{LANGTEXT}{pl}{month2}{full} ||= 'luty';
  $self->{LANGTEXT}{pl}{month3}{full} ||= 'marzec';
  $self->{LANGTEXT}{pl}{month4}{full} ||= 'kwiecień';
  $self->{LANGTEXT}{pl}{month5}{full} ||= 'maj';
  $self->{LANGTEXT}{pl}{month6}{full} ||= 'czerwiec';
  $self->{LANGTEXT}{pl}{month7}{full} ||= 'lipiec';
  $self->{LANGTEXT}{pl}{month8}{full} ||= 'sierpień';
  $self->{LANGTEXT}{pl}{month9}{full} ||= 'wrzesień';
  $self->{LANGTEXT}{pl}{month10}{full} ||= 'pażdziernik';
  $self->{LANGTEXT}{pl}{month11}{full} ||= 'listopad';
  $self->{LANGTEXT}{pl}{month12}{full} ||= 'grudzień';
  $self->{LANGTEXT}{pl}{month1}{abbr} ||= 'stycz.';
  $self->{LANGTEXT}{pl}{month2}{abbr} ||= 'luty';
  $self->{LANGTEXT}{pl}{month3}{abbr} ||= 'marz.';
  $self->{LANGTEXT}{pl}{month4}{abbr} ||= 'kwiec.';
  $self->{LANGTEXT}{pl}{month5}{abbr} ||= 'maj';
  $self->{LANGTEXT}{pl}{month6}{abbr} ||= 'czer.';
  $self->{LANGTEXT}{pl}{month7}{abbr} ||= 'lip.';
  $self->{LANGTEXT}{pl}{month8}{abbr} ||= 'sier.';
  $self->{LANGTEXT}{pl}{month9}{abbr} ||= 'wrz.';
  $self->{LANGTEXT}{pl}{month10}{abbr} ||= 'pażdz.';
  $self->{LANGTEXT}{pl}{month11}{abbr} ||= 'list.';
  $self->{LANGTEXT}{pl}{month12}{abbr} ||= 'grudz.';

  $self->{LANGINIT}{pl} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::pl - Bibulus support for Polish

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003-2004 by Andrzej Borzyszkowski and Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
