package Bibulus::it;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{it}{and} ||= 'e';
  $self->{LANGTEXT}{it}{etal} ||= 'et al.';
  $self->{LANGTEXT}{it}{editors}{full} ||= 'curatori';
  $self->{LANGTEXT}{it}{editors}{abbr} ||= 'cur.';
  $self->{LANGTEXT}{it}{editor}{full} ||= 'curatore';
  $self->{LANGTEXT}{it}{editor}{abbr} ||= 'cur.';
  $self->{LANGTEXT}{it}{edby} ||= 'curato da';
  $self->{LANGTEXT}{it}{edition}{full} ||= 'edizione';
  $self->{LANGTEXT}{it}{edition}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{it}{volume}{full} ||= 'volume';
  $self->{LANGTEXT}{it}{volume}{abbr} ||= 'vol.';
  $self->{LANGTEXT}{it}{of} ||= 'di';
  $self->{LANGTEXT}{it}{number}{full} ||= 'numero';
  $self->{LANGTEXT}{it}{number}{abbr} ||= 'no.';
  $self->{LANGTEXT}{it}{nr} ||= 'no.';
  $self->{LANGTEXT}{it}{in} ||= 'in';
  $self->{LANGTEXT}{it}{pages}{full} ||= 'pagine';
  $self->{LANGTEXT}{it}{pages}{abbr} ||= 'pp.';
  $self->{LANGTEXT}{it}{page}{full} ||= 'pagina';
  $self->{LANGTEXT}{it}{page}{abbr} ||= 'p.';
  $self->{LANGTEXT}{it}{eidpp} ||= 'pagine';
  $self->{LANGTEXT}{it}{chapter}{full} ||= 'capitolo';
  $self->{LANGTEXT}{it}{chapter}{abbr} ||= 'cap.';
  $self->{LANGTEXT}{it}{techrep}{full} ||= 'Rapporto Tecnico';
  $self->{LANGTEXT}{it}{techrep}{abbr} ||= 'Rap. Tecn.';
  $self->{LANGTEXT}{it}{mthesis} ||= 'Tesi di laurea';
  $self->{LANGTEXT}{it}{phdthesis} ||= 'Tesi di dottorato';
  $self->{LANGTEXT}{it}{edno}{1}{full} ||= 'Prima';
  $self->{LANGTEXT}{it}{edno}{1}{abbr} ||= '1a';
  $self->{LANGTEXT}{it}{edno}{2}{full} ||= 'Seconda';
  $self->{LANGTEXT}{it}{edno}{2}{abbr} ||= '2a';
  $self->{LANGTEXT}{it}{edno}{3}{full} ||= 'Terza';
  $self->{LANGTEXT}{it}{edno}{3}{abbr} ||= '3a';
  $self->{LANGTEXT}{it}{edno}{4}{full} ||= 'Quarta';
  $self->{LANGTEXT}{it}{edno}{4}{abbr} ||= '4a';
  $self->{LANGTEXT}{it}{edno}{5}{full} ||= 'Quinta';
  $self->{LANGTEXT}{it}{edno}{5}{abbr} ||= '5a';
  $self->{LANGTEXT}{it}{th} ||= 'a';
  $self->{LANGTEXT}{it}{month}{1}{full} ||= 'gennaio';
  $self->{LANGTEXT}{it}{month}{2}{full} ||= 'febbraio';
  $self->{LANGTEXT}{it}{month}{3}{full} ||= 'marzo';
  $self->{LANGTEXT}{it}{month}{4}{full} ||= 'aprile';
  $self->{LANGTEXT}{it}{month}{5}{full} ||= 'maggio';
  $self->{LANGTEXT}{it}{month}{6}{full} ||= 'giugno';
  $self->{LANGTEXT}{it}{month}{7}{full} ||= 'luglio';
  $self->{LANGTEXT}{it}{month}{8}{full} ||= 'agosto';
  $self->{LANGTEXT}{it}{month}{9}{full} ||= 'settembre';
  $self->{LANGTEXT}{it}{month}{10}{full} ||= 'ottobre';
  $self->{LANGTEXT}{it}{month}{11}{full} ||= 'novembre';
  $self->{LANGTEXT}{it}{month}{12}{full} ||= 'dicembre';
  $self->{LANGTEXT}{it}{month}{1}{abbr} ||= 'gen.';
  $self->{LANGTEXT}{it}{month}{2}{abbr} ||= 'feb.';
  $self->{LANGTEXT}{it}{month}{3}{abbr} ||= 'mar.';
  $self->{LANGTEXT}{it}{month}{4}{abbr} ||= 'apr.';
  $self->{LANGTEXT}{it}{month}{5}{abbr} ||= 'mag';
  $self->{LANGTEXT}{it}{month}{6}{abbr} ||= 'giu.';
  $self->{LANGTEXT}{it}{month}{7}{abbr} ||= 'lug.';
  $self->{LANGTEXT}{it}{month}{8}{abbr} ||= 'ago.';
  $self->{LANGTEXT}{it}{month}{9}{abbr} ||= 'set.';
  $self->{LANGTEXT}{it}{month}{10}{abbr} ||= 'ott.';
  $self->{LANGTEXT}{it}{month}{11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{it}{month}{12}{abbr} ||= 'dic.';

  $self->{LANGINIT}{it} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::it - Bibulus support for Italian

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
