package Bibulus::fi;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{fi}{and} ||= 'ja';
  $self->{LANGTEXT}{fi}{etal} ||= 'et al.';
  $self->{LANGTEXT}{fi}{editors}{full} ||= 'toimittajat';
  $self->{LANGTEXT}{fi}{editors}{abbr} ||= 'toim.';
  $self->{LANGTEXT}{fi}{editor}{full} ||= 'toimittaja';
  $self->{LANGTEXT}{fi}{editor}{abbr} ||= 'toim.';
  $self->{LANGTEXT}{fi}{edby} ||= 'toimittanut';
  $self->{LANGTEXT}{fi}{edition}{full} ||= 'painos';
  $self->{LANGTEXT}{fi}{edition}{abbr} ||= 'painos';
  $self->{LANGTEXT}{fi}{volume} ||= 'osa';
  $self->{LANGTEXT}{fi}{of} ||= 'sarjasta';
  $self->{LANGTEXT}{fi}{number}{full} ||= 'numero';
  $self->{LANGTEXT}{fi}{number}{abbr} ||= 'no.';
  $self->{LANGTEXT}{fi}{nr} ||= 'no.';
  $self->{LANGTEXT}{fi}{in} ||= 'teoksessa';
  $self->{LANGTEXT}{fi}{pages}{full} ||= 'sivut';
  $self->{LANGTEXT}{fi}{pages}{abbr} ||= 'ss.';
  $self->{LANGTEXT}{fi}{page}{full} ||= 'sivu';
  $self->{LANGTEXT}{fi}{page}{abbr} ||= 's.';
  $self->{LANGTEXT}{fi}{eidpp} ||= 'sivut';
  $self->{LANGTEXT}{fi}{chapter} ||= 'luku';
  $self->{LANGTEXT}{fi}{techrep}{full} ||= 'Tekninen Raportti';
  $self->{LANGTEXT}{fi}{techrep}{abbr} ||= 'Tekn. Rap.';
  $self->{LANGTEXT}{fi}{mthesis} ||= 'pro gradu';
  $self->{LANGTEXT}{fi}{phdthesis} ||= 'väitöskirja';
  $self->{LANGTEXT}{fi}{edno}{1}{full} ||= 'Ensimmäinen';
  $self->{LANGTEXT}{fi}{edno}{1}{abbr} ||= '1.';
  $self->{LANGTEXT}{fi}{edno}{2}{full} ||= 'Toinen';
  $self->{LANGTEXT}{fi}{edno}{2}{abbr} ||= '2.';
  $self->{LANGTEXT}{fi}{edno}{3}{full} ||= 'Kolmas';
  $self->{LANGTEXT}{fi}{edno}{3}{abbr} ||= '3.';
  $self->{LANGTEXT}{fi}{edno}{4}{full} ||= 'Neljäs';
  $self->{LANGTEXT}{fi}{edno}{4}{abbr} ||= '4.';
  $self->{LANGTEXT}{fi}{edno}{5}{full} ||= 'Viides';
  $self->{LANGTEXT}{fi}{edno}{5}{abbr} ||= '5.';
  $self->{LANGTEXT}{fi}{st} ||= '.';
  $self->{LANGTEXT}{fi}{nd} ||= '.';
  $self->{LANGTEXT}{fi}{rd} ||= '.';
  $self->{LANGTEXT}{fi}{th} ||= '.';
  $self->{LANGTEXT}{fi}{month}{1} ||= 'tammikuu';
  $self->{LANGTEXT}{fi}{month}{2} ||= 'helmikuu';
  $self->{LANGTEXT}{fi}{month}{3} ||= 'maaliskuu';
  $self->{LANGTEXT}{fi}{month}{4} ||= 'huhtikuu';
  $self->{LANGTEXT}{fi}{month}{5} ||= 'toukokuu';
  $self->{LANGTEXT}{fi}{month}{6} ||= 'kesäkuu';
  $self->{LANGTEXT}{fi}{month}{7} ||= 'heinäkuu';
  $self->{LANGTEXT}{fi}{month}{8} ||= 'elokuu';
  $self->{LANGTEXT}{fi}{month}{9} ||= 'syyskuu';
  $self->{LANGTEXT}{fi}{month}{10} ||= 'lokakuu';
  $self->{LANGTEXT}{fi}{month}{11} ||= 'marraskuu';
  $self->{LANGTEXT}{fi}{month}{12} ||= 'joulukuu';

  $self->{LANGINIT}{fi} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::fi - Bibulus support for Finnish

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
