package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# make labels

sub labels {
  my $self = shift;
  if (!defined($self->{STYLE}{cite})) {
    $self->numlabels;		# default
  } elsif ($self->{STYLE}{cite} eq 'numerical') {
    $self->numlabels;
  } elsif ($self->{STYLE}{cite} eq 'ay_alk') {
    $self->ay_alk_labels;
  } else {
    croak "Unknown label type";
  }
}

# special for listing entire databases; the cite key is used as the
# label so it may be listed
sub citekey_labels {
  my $self = shift;
  my $i;
  foreach $i (@{$self->{EL}}) {
    my $e = new XML::Twig::Elt('label', $i->atts->{id});
    $e->paste('last_child', $i);
  }
}

# for the apalike.sty of Oren Patashnik:
# \bibitem[author, year]{key}
sub ay_alk_labels {
  my $self = shift;
  my ($author, $year);
  my $i;
  foreach $i (@{$self->{EL}}) {
    ($author, $year) = _authoryear($i);
    my $e = new XML::Twig::Elt('label', "$author, $year");
    $e->paste('last_child', $i);
  }
}

# for astronomy family of styles:
# \bibitem[\protect\astroncite{author}{year}]{key}
sub ay_ast_labels {
  my $self = shift;
  my ($author, $year);
  my $i;
  foreach $i (@{$self->{EL}}) {
    ($author, $year) = _authoryear($i);
    my $e = new XML::Twig::Elt('label', "\\protect\\astroncite{$author}{$year}");
    $e->paste('last_child', $i);
  }
}

sub _authoryear {
  my ($el) = @_;
  my $author;
  if (defined($el->first_child('author'))
     and defined($el->first_child('author')->first_child('name'))
     and defined($el->first_child('author')->first_child('name')->first_child('family'))) {
    $author = $el->first_child('author')->first_child('name')->first_child('family')->text;
  } else {
    $author = '';
  }
  my $year = '';
  defined($el->first_child('year')) and $year = $el->first_child('year')->text;
  return ($author, $year);
}

# uses first three letters of first author's name, regardless of how
# many authors
sub alph1labels {
  my $self = shift;
  my $label;
  my $i;
  foreach $i (@{$self->{EL}}) {
    $label = substr($i->first_child('author')->first_child('name')->first_child('family')->text, 0, 3) .
      substr($i->first_child('year')->text, -2);
    my $e = new XML::Twig::Elt('label', $label);
    $e->paste('last_child', $i);
  }
}

# uses first author's whole name
sub alphflabels {
  my $self = shift;
  my $label;
  my $i;
  foreach $i (@{$self->{EL}}) {
    $label = $i->first_child('author')->first_child('name')->first_child('family')->text . substr($i->first_child('year')->text, -2);
    my $e = new XML::Twig::Elt('label', $label);
    $e->paste('last_child', $i);
  }
}

# an abbreviation of the author names plus year: First three letters
# of single author, or first letters of first three authors.
sub alphalabels {
  my $self = shift;
  my $label;
  my $i;
  my @lastnames;

  foreach $i (@{$self->{EL}}) {

    # Get all the last names
    @lastnames = ();
    foreach ($i->first_child('author')->children) {
      push @lastnames, $_->first_child('family')->text;
    }

    # Now create the label
    if (@lastnames == 0) {
      warn "No lastnames found!";
      $label = 'XXX';
    } elsif (@lastnames == 1) {
      $label = substr($lastnames[0], 0, 3);
    } elsif (@lastnames == 2) {
      $label = substr($lastnames[0], 0, 1) . substr($lastnames[1], 0, 1);
    } else {
      $label = substr($lastnames[0], 0, 1) . substr($lastnames[1], 0, 1)
	. substr($lastnames[2], 0, 1);
    }
    $label .= substr($i->first_child('year')->text, -2);

    # And add it to the tree
    my $e = new XML::Twig::Elt('label', $label);
    $e->paste('last_child', $i);
  }
}

# Numerical labels.
sub numlabels {
  my $self = shift;
  my $label = 1;
  my $i;
  foreach $i (@{$self->{EL}}) {
    my $e = new XML::Twig::Elt('label', $label++);
    $e->paste('last_child', $i);
  }
}

1;
