package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

sub formatentry {
  my $self = shift;
  my ($e) = @_;
  my $t;

  my $attr = $e->atts;

  $self->setstate('beforeall');
  $self->{DIDWRITESOMETHING} = 0;

  unless (defined($attr->{id})) {  # an entry must have an id
    warn "No ID for entry.\n";
    return;
  }

  $self->{CUREL} = $e;
  $self->{CURR} = $self->item_start($attr->{id}, $e->field('label'));

  my $et = $e->tag;    # entry type

  if ($et eq 'article') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle();
    $self->formatnewblock;
    if (!defined($e->first_child('crossref'))) {
      $self->formatjournal;
      $self->formatvolnumpages;
      $self->formatdateasyear;
    } else {
      $self->formatcrossref;
      $self->formatpages;
    }
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'magazine') {
    $self->formattitle('plain');
    $self->formatvolnumpages;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'book') {
    $self->formateditors;
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('emph');
    if (!defined($e->first_child('crossref'))) {
      $self->formatbvolume;
      $self->formatnewblock;
      $self->formatnumberseries;
      $self->newsentence;
      $self->formatpublisheraddress;
    } else {
      $self->formatcrossref;
      $self->formatpages;
    }
    $self->formatedition;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'booklet') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('plain');
    $self->formatnewblock
      unless ($self->empty('howpublished') and $self->empty('address'));
    $self->formathowpublished;
    $self->formataddress;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'misc') {
    $self->formatauthors;
    $self->formatnewblock
      unless ($self->empty('howpublished') and $self->empty('title'));
    $self->formattitle unless $self->empty('title');
    $self->formatnewblock unless $self->empty('howpublished');
    $self->formathowpublished;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

    if ($self->empty('author') and
	$self->empty('title') and
	$self->empty('howpublished') and
	$self->empty('month') and
	$self->empty('year') and
	$self->empty('note')) {
      $self->warning("All relevant fields are empty");
    }

  } elsif ($et eq 'thesis') {
    $self->formatauthors;
    $self->formatnewblock;
    if ($self->getatt('type') eq 'phd') {
      $self->formattitle('emph');
    } else {
      $self->formattitle('plain');
    }
    $self->formatnewblock;
    $self->formatthesistype;
    $self->formatinstitution;
    $self->formataddress;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'unpublished') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('plain');
    $self->formatnewblock;
    # warning: <note> should come before <year>!
    $self->formatdateasyear;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'report') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('plain');
    $self->formatnewblock;
    $self->formattrnumber;
    $self->formatinstitution;
    $self->formataddress;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'inbook') {
    # Some both-and/either-or checking has been removed from next two lines:
    $self->formateditors;
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('emph');
    if($self->empty('crossref')) {
      $self->formatbvolume;
      $self->formatchapterpages;
      $self->formatnewblock;
      $self->formatnumberseries;
      $self->newsentence;
      $self->formatpublisheraddress;
    } else {
      $self->formatchapterpages;
      $self->formatnewblock;
      $self->formatcrossref;
    }
    $self->formatedition;
    $self->formatdateasyear;;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'manual') {
    if($self->empty('author')) {
      unless($self->empty('institution')) {
	$self->formatinstitution;
	$self->formataddress;
      }
    } else {
      $self->formatauthors;
    }
    $self->formatnewblock;
    $self->formattitle('emph');
    if($self->empty('author')) {
      if($self->empty('institution') and !$self->empty('address')) {
	$self->formatnewblock;
	$self->formataddress;
      }
    } else {
      $self->formatnewblock
	unless $self->empty('institution') and $self->empty('address');
      $self->formatinstitution;
      $self->formataddress;
    }
    $self->formatedition;
    $self->formatdateasyear;
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'incollection') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('plain');
    $self->formatnewblock;
    if ($self->empty('crossref')) {
      $self->formatinedbooktitle;
      $self->formatbvolume;
      $self->formatnumberseries;
      $self->formatchapterpages;
      $self->newsentence;
      $self->formatpublisher;
      $self->formataddress;
      $self->formatedition;
      $self->formatdateasyear;
    } else {
      $self->formatincollinproccrossref;
      $self->formatpages;
    }
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'inproceedings') {
    $self->formatauthors;
    $self->formatnewblock;
    $self->formattitle('plain');
    $self->formatnewblock;
    if ($self->empty('crossref')) {
      $self->formatinedbooktitle;
      $self->formatbvolume;
      $self->formatnumberseries;
      $self->formatpages;
      if ($self->empty('address')) {
	$self->empty('institution') and $self->empty('publisher')
	  and $self->newsentence;
	$self->formatinstitution;
	$self->formatpublisher;
	$self->formatdateasyear;
      } else {
	$self->formataddress;
	$self->formatdateasyear;
	$self->newsentence;
	$self->formatinstitution;
	$self->formatpublisher;
      }
    } else {
      $self->formatincollinproccrossref;
      $self->formatpages;
    }

    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } elsif ($et eq 'proceedings') {
    if ($self->empty('editor')) {
      $self->formatinstitution;
    } else {
      $self->formateditors;
    }
    $self->formatnewblock;
    $self->formattitle('emph');
    $self->formatbvolume;
    $self->formatnumberseries;
    if ($self->empty('address')) {
      if ($self->empty('editor')) {
	$self->empty('publisher') and $self->newsentence;
      } else {
	$self->empty('institution') and $self->empty('publisher') and $self->newsentence;
      }
      $self->formatpublisher;
      $self->formatdateasyear;
    } else {
      $self->formataddress;
      $self->formatdateasyear;
      $self->newsentence;
      $self->empty('editor') or $self->formatinstitution;
      $self->formatpublisher;
    }
    $self->formatnewblock;
    $self->formatrest;
    $self->finentry;

  } else {
    $self->{CURR} .= " [$et: NOT IMPLEMENTED] ";
  }

  $self->{CURR} .= $self->item_end;
}

1;
