/*
 * Decompiled with CFR 0.152.
 */
package jolon.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jolon.xml.XMLAttribute;
import jolon.xml.XMLCompatible;

public class XMLObject
implements XMLCompatible {
    String tag;
    Object data;
    Vector children;
    Vector attributes;
    public static final int END = 1;
    public static final int LITERAL = 4;
    public static final int EXT_T_1 = 81;
    public static final int STR_T = 83;

    public XMLObject(String string) {
        this.tag = string;
        this.data = this.data;
        this.children = new Vector();
        this.attributes = new Vector();
    }

    public void add(XMLObject xMLObject) {
        this.children.addElement(xMLObject);
    }

    @Override
    public void fromXML(XMLObject xMLObject) {
    }

    @Override
    public XMLCompatible addXMLChild(XMLCompatible xMLCompatible) {
        this.children.addElement(xMLCompatible);
        return xMLCompatible;
    }

    public XMLObject getAt(int n) {
        return (XMLObject)this.children.elementAt(n);
    }

    public void add(XMLAttribute xMLAttribute) {
        this.attributes.addElement(xMLAttribute);
    }

    public void addAttribute(String string, Object object) {
        this.add(new XMLAttribute(string, object));
    }

    public void addAttribute(String string, int n) {
        this.add(new XMLAttribute(string, new Integer(n)));
    }

    public void addAttribute(String string, double d) {
        this.add(new XMLAttribute(string, new Double(d)));
    }

    public void addAttribute(String string, boolean bl) {
        this.add(new XMLAttribute(string, new Boolean(bl)));
    }

    public void writeXML(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.writeXML(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeXML(Writer writer) {
        try {
            writer.write("<?xml version=\"1.0\"?>\n");
            this.write(writer, 0);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    protected void write(Writer writer, int n) throws IOException {
        this.writeTabs(writer, n);
        writer.write("<" + this.tag);
        this.writeAttributes(writer);
        if (this.children.size() > 0 || this.data != null) {
            writer.write(">\n");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                ((XMLObject)enumeration.nextElement()).write(writer, n + 1);
            }
            if (this.data != null) {
                this.writeTabs(writer, n + 1);
                writer.write(this.data.toString());
            }
            this.writeTabs(writer, n);
            writer.write("</" + this.tag + ">" + "\n");
        } else {
            writer.write("/>\n");
        }
    }

    protected void writeTabs(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write("\t");
        }
    }

    protected void writeAttributes(Writer writer) throws IOException {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            writer.write(" ");
            ((XMLAttribute)enumeration.nextElement()).write(writer);
        }
    }

    public void writeWBXML(File file) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.writeWBXML(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeWBXML(OutputStream outputStream) {
        try {
            this.writeWBXMLversion(outputStream);
            this.writeWBXMLpublicID(outputStream);
            this.writeWBXMLcharSet(outputStream);
            Hashtable hashtable = this.writeWBXMLstringTable(outputStream);
            this.writeWBXML(outputStream, hashtable);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void writeWBXMLversion(OutputStream outputStream) throws IOException {
        outputStream.write(1);
    }

    public void writeWBXMLpublicID(OutputStream outputStream) throws IOException {
        outputStream.write(0);
    }

    public void writeWBXMLcharSet(OutputStream outputStream) throws IOException {
        outputStream.write(0);
    }

    public Hashtable writeWBXMLstringTable(OutputStream outputStream) throws IOException {
        Object object;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("Jolon's public id", new Integer(0));
        this.generateStringTable(hashtable);
        int n = 0;
        Object object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            hashtable.put((String)object, new Integer(n));
            n += ((String)object).length() + 1;
        }
        this.writeWBXMLmultibyteInteger(outputStream, n);
        System.out.println("String table length = " + n);
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            object2 = (String)object.nextElement();
            this.writeWBXMLnullTerminatedString(outputStream, (String)object2);
        }
        return hashtable;
    }

    public void generateStringTable(Hashtable hashtable) {
        Object object;
        Object object2;
        hashtable.put(this.tag, new Integer(0));
        if (!this.attributes.isEmpty()) {
            object2 = this.attributes.elements();
            while (object2.hasMoreElements()) {
                object = (XMLAttribute)object2.nextElement();
                hashtable.put(((XMLAttribute)object).getName(), new Integer(0));
                if (((XMLAttribute)object).getData() instanceof Double) continue;
                hashtable.put(((XMLAttribute)object).getDataAsString(), new Integer(0));
            }
        }
        if (!this.children.isEmpty()) {
            object = this.children.elements();
            while (object.hasMoreElements()) {
                object2 = (XMLObject)object.nextElement();
                ((XMLObject)object2).generateStringTable(hashtable);
            }
        }
    }

    public void writeWBXMLmultibyteInteger(OutputStream outputStream, int n) throws IOException {
        if (n == 0) {
            outputStream.write(0);
        } else {
            int n2 = 28;
            boolean bl = false;
            do {
                int n3 = n >> n2 & 0x7F;
                if (!bl && n3 > 0) {
                    bl = true;
                }
                if (!bl) continue;
                if (n2 > 0) {
                    n3 |= 0x80;
                }
                outputStream.write(n3);
            } while ((n2 -= 7) >= 0);
        }
    }

    public void writeWBXMLnullTerminatedString(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(), 0, string.length());
        outputStream.write(0);
    }

    public void writeWBXML(OutputStream outputStream, Hashtable hashtable) throws IOException {
        Object object;
        Object object2;
        int n = 4;
        if (!this.attributes.isEmpty()) {
            n |= 0x80;
        }
        if (!this.children.isEmpty()) {
            n |= 0x40;
        }
        outputStream.write(n);
        this.writeWBXMLstringIndex(outputStream, hashtable, this.tag);
        if (!this.attributes.isEmpty()) {
            object2 = this.attributes.elements();
            while (object2.hasMoreElements()) {
                object = (XMLAttribute)object2.nextElement();
                outputStream.write(4);
                this.writeWBXMLstringIndex(outputStream, hashtable, ((XMLAttribute)object).getName());
                Object object3 = ((XMLAttribute)object).getData();
                if (object3 instanceof Double) {
                    Double d = (Double)object3;
                    int n2 = Float.floatToIntBits(d.floatValue());
                    outputStream.write(81);
                    this.writeWBXMLmultibyteInteger(outputStream, n2);
                    continue;
                }
                outputStream.write(83);
                this.writeWBXMLstringIndex(outputStream, hashtable, ((XMLAttribute)object).getDataAsString());
            }
            outputStream.write(1);
        }
        if (!this.children.isEmpty()) {
            object = this.children.elements();
            while (object.hasMoreElements()) {
                object2 = (XMLObject)object.nextElement();
                ((XMLObject)object2).writeWBXML(outputStream, hashtable);
            }
            outputStream.write(1);
        }
    }

    public void writeWBXMLstringIndex(OutputStream outputStream, Hashtable hashtable, String string) throws IOException {
        int n = (Integer)hashtable.get(string);
        this.writeWBXMLmultibyteInteger(outputStream, n);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public XMLObject getChild(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLObject xMLObject = (XMLObject)enumeration.nextElement();
            if (!xMLObject.getTag().equalsIgnoreCase(string)) continue;
            return xMLObject;
        }
        return null;
    }

    public boolean hasChild(String string) {
        return this.getChild(string) != null;
    }

    public XMLCompatible getXMLChild(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLCompatible xMLCompatible = (XMLCompatible)enumeration.nextElement();
            if (!xMLCompatible.getTag().equalsIgnoreCase(string)) continue;
            return xMLCompatible;
        }
        return null;
    }

    public XMLAttribute getAttribute(String string) {
        if (string != null) {
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                String string2;
                XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
                if (xMLAttribute == null || (string2 = xMLAttribute.getName()) == null || !string2.equalsIgnoreCase(string)) continue;
                return xMLAttribute;
            }
        }
        return null;
    }

    public XMLObject getChildAt(int n) {
        return (XMLObject)this.children.elementAt(0);
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag + " : ");
        if (this.data != null) {
            stringBuffer.append(this.data.toString().trim() + " ");
        }
        if ((enumeration = this.children.elements()).hasMoreElements()) {
            stringBuffer.append("{");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" [ ");
                stringBuffer.append(((XMLObject)enumeration.nextElement()).toString());
                stringBuffer.append(" ]");
            }
            stringBuffer.append("}");
        }
        if ((enumeration = this.attributes.elements()).hasMoreElements()) {
            stringBuffer.append("{");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" [ ");
                stringBuffer.append(enumeration.nextElement().toString());
                stringBuffer.append(" ]");
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public String getAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        String string3 = string2;
        if (xMLAttribute != null) {
            string3 = xMLAttribute.getDataAsString();
        }
        return string3;
    }

    public int getAttribute(String string, int n) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        int n2 = n;
        if (xMLAttribute != null) {
            n2 = xMLAttribute.getDataAsInt();
        }
        return n2;
    }

    public double getAttribute(String string, double d) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        double d2 = d;
        if (xMLAttribute != null) {
            d2 = xMLAttribute.getDataAsDouble();
        }
        return d2;
    }

    public boolean getAttribute(String string, boolean bl) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        boolean bl2 = bl;
        if (xMLAttribute != null) {
            bl2 = xMLAttribute.getDataAsBoolean();
        }
        return bl2;
    }

    public String getAttributeAsString(String string, String string2) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        String string3 = string2;
        if (xMLAttribute != null) {
            string3 = xMLAttribute.getDataAsString();
        }
        return string3;
    }

    public int getAttributeAsInt(String string, int n) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        int n2 = n;
        if (xMLAttribute != null) {
            n2 = xMLAttribute.getDataAsInt();
        }
        return n2;
    }

    public double getAttributeAsDouble(String string, double d) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        double d2 = d;
        if (xMLAttribute != null) {
            d2 = xMLAttribute.getDataAsDouble();
        }
        return d2;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        XMLAttribute xMLAttribute = this.getAttribute(string);
        boolean bl2 = bl;
        if (xMLAttribute != null) {
            bl2 = xMLAttribute.getDataAsBoolean();
        }
        return bl2;
    }
}

