/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.HashMap;
import jolon.xml.CDATA;
import jolon.xml.XMLObject;

public class ThmlConverter
extends GoBibleCreator {
    public static final String THML_TAG = "ThML";
    public static final String THML_BODY_TAG = "ThML.body";
    public static final String TESTAMENT_TAG = "div1";
    public static final String BOOK_TAG = "div2";
    public static final String BOOK_NAME_ATTRIBUTE = "title";
    public static final String BOOK_SHORT_NAME_ATTRIBUTE = "id";
    public static final String CHAPTER_TAG = "div3";
    public static final String CHAPTER_NUMBER_ATTRIBUTE = "title";
    public static final String PARAGRAPH_TAG = "p";
    public static final String VERSE_TAG = "scripture";
    public static final String RED_TAG = "span";
    public static final String RED_TAG_ATTRIBUTE = "class";
    public static final String RED_TAG_VALUE = "red";
    public static final char STYLE_RED = '\u0001';

    public HashMap parse(XMLObject thml) {
        return this.parseBooks(thml, THML_BODY_TAG, TESTAMENT_TAG, BOOK_TAG, "title", BOOK_SHORT_NAME_ATTRIBUTE);
    }

    public boolean isChapter(XMLObject xml) {
        return xml.getTag().equals(CHAPTER_TAG);
    }

    public int getChapterNumber(XMLObject xml) {
        String title = xml.getAttribute("title", "*Error no title attribute*");
        int spaceIndex = title.lastIndexOf(32);
        return Integer.parseInt(title.substring(spaceIndex + 1));
    }

    public void parseChapter(XMLObject xml, Chapter chapter) {
        String verse = null;
        Enumeration e = xml.getChildren();
        while (e.hasMoreElements()) {
            XMLObject xmlParagraph = (XMLObject)e.nextElement();
            if (!xmlParagraph.getTag().equals(PARAGRAPH_TAG)) continue;
            verse = this.parseParagraphs(xmlParagraph, chapter, verse);
        }
        if (verse != null && !verse.equals("")) {
            this.addNewVerse(chapter, verse);
        }
    }

    private String parseParagraphs(XMLObject paragraph, Chapter chapter, String verse) {
        Enumeration e = paragraph.getChildren();
        while (e.hasMoreElements()) {
            String newVerseData;
            XMLObject xml = (XMLObject)e.nextElement();
            if (xml.getTag().equals(VERSE_TAG)) {
                if (verse != null) {
                    this.addNewVerse(chapter, verse);
                }
                verse = "";
                continue;
            }
            if (verse == null) continue;
            if (xml instanceof CDATA) {
                verse = verse + xml.getTag();
                continue;
            }
            if (xml.getTag().equals("sup") || xml.getTag().equals(RED_TAG) && xml.getAttribute(RED_TAG_ATTRIBUTE, "").equals("chap") || (newVerseData = ThmlConverter.extractCDATA(xml)).length() <= 0) continue;
            if (xml.getTag().equals(RED_TAG) && xml.getAttribute(RED_TAG_ATTRIBUTE, "").equals(RED_TAG_VALUE)) {
                verse = verse + '\u0001' + newVerseData + '\u0001';
                continue;
            }
            verse = verse + newVerseData;
        }
        return verse;
    }

    private void addNewVerse(Chapter chapter, String verse) {
        String verseString = this.trim(verse).replace('\n', ' ');
        if (verseString.indexOf(38) >= 0) {
            verseString = this.convertAmpersands(verseString);
        }
        chapter.verses.addElement(verseString);
        chapter.allVerses.append(verseString);
    }
}

