<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h3><?php echo Locale_Translate::_("Client mode") ?></h3>
<p>
<a href="?client=">
<?php if ($this->client == true) { ?> ☑ <?php } else { ?> ☐ <?php } ?>
</a>
<?php echo Locale_Translate::_("Enable client mode.") ?>
</p>

<?php if ($this->client == true) { ?>
<form action="client.php" name="server" method="post">
  <p>
    <?php echo Locale_Translate::_("Address of Bibledit-Web Server on the Internet:") ?>
    <input type="text" name="url" maxlength="256" value="<?php echo $this->url ?>" />
    <input type="submit" name="save" value="<?php echo Locale_Translate::_("Save") ?>" />
  </p>
</form>
<p><a href="?test="><?php echo Locale_Translate::_("Test the connection to the server.") ?></a></p>
<?php } ?>
<p class="error"><?php echo $this->error ?></p>
<p class="success"><?php echo $this->success ?></p>

<br>

<p>
  <?php echo Locale_Translate::_("Bibledit-Web normally runs on a website in server mode.") ?>
  <?php echo Locale_Translate::_("To work properly, it needs to run for 24 hours a day.") ?>
  <?php echo Locale_Translate::_("The translation teams work on that website.") ?>
</p>
<p>
  <?php echo Locale_Translate::_("When client mode is enabled, Bibledit-Web can be used offline as a client on a local computing device.") ?>
</p>

<br>

<p>
  <?php echo Locale_Translate::_("Client mode affects the following:") ?>
</p>
<ul>
<li>
  <?php echo Locale_Translate::_("Does not send or receive email.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("Can synchronize the local Consultation Notes with the Consultation Notes on a Bibledit-Web server.") ?>
</li>
</ul>
