<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

if (php_sapi_name () != "cli") return;

require_once ("../bootstrap/bootstrap.php");

$object = $argv[1];
$database_config_bible = Database_Config_Bible::getInstance();
$url = $database_config_bible->getRemoteRepositoryUrl ($object);
$directory = Filter_Git::git_directory ($object);


// Temporarily store the .git directory.
$tempdirectory = tempnam (sys_get_temp_dir(), '');
unlink ($tempdirectory);
mkdir ($tempdirectory);
$renamed = rename ("$directory/.git", "$tempdirectory/.git");
if (!$renamed) {
  $message = gettext ("Failed to temporarily store the .git directory");
  echo "$message\n";
}

// Completely remove all data from the git directory.
Filter_Rmdir::rmdir ($directory);
mkdir ($directory);

// Move the .git directory back into place.
$renamed = rename ("$tempdirectory/.git", "$directory/.git");
if (!$renamed) {
  $message = gettext ("Failed to restore the .git directory");
  echo "$message\n";
}

// Put our data into the repository staging area.
$message = gettext ("Step 1/2: Exporting the local data to the local repository");
echo "$message\n";
if ($object == "consultationnotes") {
  Filter_Git::notesDatabase2filedata ($directory, true);
} else {
  Filter_Git::syncBible2Git ($object, $directory, true);
}

// Directory made fit for use by the shell.
$shelldirectory = escapeshellarg ($directory);

// Add and commit the data.
$command = "cd $shelldirectory; git add .";
echo "$command\n";
exec ($command, $output, $exit_code);
echo "Exit code $exit_code\n";
if ($exit_code != 0) {
  foreach ($output as $line) {
    echo "$line\n";
  }
}
$command = "cd $shelldirectory; git commit -a -m admin-sync";
echo "$command\n";
exec ($command, $output, $exit_code);
echo "Exit code $exit_code\n";
if ($exit_code != 0) {
  foreach ($output as $line) {
    echo "$line\n";
  }
}

// Push data to remote repository.
echo gettext ("Step 2/2: Pushing the data to the remote repository") . "\n";
$command = "cd $shelldirectory; git push 2>&1";
echo "$command\n";
exec ($command, $output, $exit_code);
if ($exit_code == 0) {
  echo gettext ("Your data was pushed to the remote repository successfully, overwriting any data that was there before.") . "\n";
} else {
  echo "Exit code $exit_code\n";
  foreach ($output as $line) {
    echo "$line\n";
  }
  echo gettext ("Pushing your data to the remote repository failed.") . "\n";
}

// Be sure to sync in case somebody unplugs the USB flash drive before data was fully written to it.
exec ("sync");

$database_shell = Database_Shell::getInstance ();
$database_shell->stopProcess ("collaboration_take_yourself", 0);

?>
