<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("bootstrap/bootstrap.php");


class Tasks_Logic
{


  static public function run ()
  {
    // The tasks runner will be started when there are tasks to run
    // and the watch dog indicates it is no longer alive,
    $database_watchdog = Database_Watchdog::getInstance ();
    $alive = $database_watchdog->alive ();
    if (!$alive) {
      $directory = __DIR__;
      shell_exec ("cd $directory; php run.php > /dev/null 2>&1 &");
    }
  }
  
  
  static public function queue ($command)
  {
    $database_tasks = Database_Tasks::getInstance ();
    // Queue the task with medium (5) priority.
    $database_tasks->queue ($command, 5);
  }


  static public function runs ($process)
  {
    $database_tasks = Database_Tasks::getInstance ();
    return $database_tasks->runs ($process);
  }


  static public function queued ($process)
  {
    $database_tasks = Database_Tasks::getInstance ();
    return $database_tasks->queued ($process);
  }
  
  
  static public function expire ()
  {
    $database_tasks = Database_Tasks::getInstance ();
    $pids = $database_tasks->expired ();
    foreach ($pids as $pid) {
      posix_kill ($pid, SIGKILL);
      $database_logs = Database_Logs::getInstance ();
      $database_logs->log ("Killing stuck process with PID $pid", Filter_Roles::ADMIN_LEVEL);
    }
  }


}


?>
