<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Timer_Logger
{


  // This function starts a process, and returns immediately after that.
  // The process keeps running in the background.
  // $workingfolder: The working folder.
  // $interpreter: The interpreter, e.g. "php".
  // $script: The script, e.g. "process.php".
  // $parameters: Array of parameters to pass to the script.
  // $name: The name of this process, for later reference.
  // $log: Whether to create an entry in the logbook stating the command to start this process.
  public function startProcess ($workingfolder, $interpreter, $script, $parameters = NULL, $name = NULL, $log = true)
  {
    $command = "";

    if ($workingfolder != "") {
      $workingfolder = escapeshellarg ($workingfolder);
      $command .= "cd $workingfolder; ";
    }

    $script = escapeshellarg ($script);

    $logfile = tempnam (sys_get_temp_dir (), "");
    
    if ($parameters) {
      foreach ($parameters as &$parameter) {
        $parameter = escapeshellarg ($parameter);
      }
      $parameters = implode (" ", $parameters);
    } else {
      $parameters = "";
    }

    $command .= "$interpreter $script $parameters > $logfile 2>&1 & echo $!";

    $pid = shell_exec ($command);
    $pid = intval ($pid);

    $database_logger = Database_Logger::getInstance ();
    if (!$name) $name = "";
    $database_logger->record ($pid, $logfile, $name);

    if ($log) {
      $database_logs = Database_Logs::getInstance ();
      $database_logs->log ("log: command: $command - pid: $pid");
    }
  }


  public function handleUsedLogFiles ()
  {
    $database_logger = Database_Logger::getInstance ();
    $logfiles = $database_logger->getAll ();
    foreach ($logfiles as $pid => $filename) {
      if (file_exists ('/proc/'.$pid)) continue;
      $database_logger->erase ($pid);
      if (!file_exists ($filename)) continue;
      $lines = file ($filename);
      unlink ($filename);
      $database_logs = Database_Logs::getInstance ();
      foreach ($lines as $line) {
        $database_logs->log (basename ($filename) . ": " . $line);
      }
    }
  }
  
  
  public function killExpiredPIDs ()
  {
    $database_logger = Database_Logger::getInstance ();
    $pids = $database_logger->getExpiredPIDs ();
    foreach ($pids as $pid) {
      posix_kill ($pid, SIGKILL);
      $database_logs = Database_Logs::getInstance ();
      $database_logs->log ("Killing stuck process with PID $pid");
    }
  }
  
  
}


?>
