<h1>{t}Introduction{/t}</h1>
<p>{t}Bibledit is a web-based application for translating the Bible. It is part of the Bibledit suite.{/t}</p>
<br>
<p>{t}People can sign up for an account and log in.{/t}</p>
<p>{t}Each user has a certain role within the application.{/t}</p>
<p>{t}The first role is "Member". A member is somebody who has signed up to the site, and has confirmed this signup through his email.{/t}</p>
<p>{t}The second role is "Consultant". Consultants are people who can be consulted because of their knowledge of the original language such as Hebrew or Greek, or because of their knowledge of their target language in case they are language scholars, or for any other knowledge they have.{/t}</p>
<p>{t}The next role is "Translator". These are the ones that have all the rights of the Consultant, but in addition can change the Bible text.{/t}</p>
<p>{t}Then there's the "Manager". The manager has all the privileges of the previous levels, but in addition can add books to the Bible, delete books, add chapters, copy Bibles, and so on. The manager can assign privileges to the translators, consultants, and so on.{/t}</p>
<p>{t}Finally, there is the "Administrator". The administrator has all rights to do anything, and will do the technical setup and maintenance of the site.{/t}</p>
<br>
<p>{t}Everybody who has an account can enable the personal notifications. Those who have switched the relevant notifications on can receive email from Bibledit-Web. They receive email when new consultation notes get created, or when consultation notes get changed, or when consultation notes get assigned to them. They can also get automatic daily email detailing the changes that have been made in the Bible since the previous email.{/t}</p>
<br>
<p>{t}Everybody who has an account can create consultation notes by email, and respond to these by email.{/t}</p>
<br>
<p>{t}Members can view and download all exported Bibles and lists with recent changes in the Bibles.{/t}</p>
<br>
<p>{t}Consultants can create consultation notes online, view these, set parameters for these, assign the notes to people, and delete notes.{/t}</p>
<br>
<p>{t}Translators can do the following things:{/t}</p>
<p>* {t}Edit the Bible text.{/t}</p>
<p>* {t}Switch the stylesheet.{/t}</p>
<p>* {t}View and suppress results of the automatic checks.{/t}</p>
<br>
<p>{t}Managers can do several things:{/t}</p>
<p>* {t}Edit the Bible in raw USFM format.{/t}</p>
<p>* {t}Send and receive the Bible text. This means that they can synchronize the Bible text with a remote git repository. In this way they can collaborate with people who use Bibledit-Gtk.{/t}</p>
<p>* {t}View and clear the logbook.{/t}</p>
<p>* {t}Process the changes, so that lists are created, and email is sent out.{/t}</p>
<p>* {t}View and edit people who have an account, and create new accounts.{/t}</p>
<p>* {t}Create and delete Bibles, books, chapters, and import USFM data.{/t}</p>
<p>* {t}Initiate the daily export of selected Bibles to OpenDocument, USFM, html, Online Bible.{/t}</p>
<p>* {t}Create and edit versification systems.{/t}</p>
<p>* {t}Create and edit stylesheets.{/t}</p>
<p>* {t}Import consultation notes from Bibledit-Gtk and remove duplicates.{/t}</p>
<p>* {t}Deal with automatic hyphenation when exporting to OpenDocument.{/t}</p>
<p>* {t}Make settings for the automatic check and select Bibles to run them on.{/t}</p>
<br>
<p>{t}Administrator can do several things:{/t}</p>
<p>* {t}Set up Bibledit-Web's email account.{/t}</p>
<p>* {t}Create backups and restore them.{/t}</p>
<p>* {t}Set up collaboration through setting up a connection with a remote git repository.{/t}</p>
<p>* {t}Maintain the database.{/t}</p>
<p>* {t}Set the site's timezone.{/t}</p>
<p>* {t}Set the site's language.{/t}</p>
<p>* {t}View the PHP Info.{/t}</p>
