<h1>{t}Typesetting in Adobe InDesign{/t}</h1>

<h2>{t}Introduction{/t}</h2>
<p>{t}See the online help about typesetting for more information about some general principles.{/t}</p>
<p>{t}I use LibreOffice and Adobe InDesign.{/t}</p>

<h2>{t}Chapter numbers in drop caps{/t}</h2>
<p>{t}Bibledit-Web normally exports chapter numbers in bigger font in a text frame.{/t}</p>
<p>{t}In InDesign it is helpful to have these in drop caps.{/t}</p>
<p>{t}Go to Bibledit-Web, menu Management / Export.{/t}</p>
<p>{t}There is a setting for using frames in the drop caps. Switch it off.{/t}</p>
<p>{t}Do a fresh export.{/t}</p>

<h2>{t}Creating a new document{/t}</h2>
<p>{t}Typesetting in InDesign starts with creating a new document.{/t}</p>
<p>{t}Choose menu File / New / Document, or press Ctrl-N.{/t}</p>
<p>{t}In the New Document dialog, make some settings.{/t}</p>
<p>{t}Facing Pages: on.{/t}</p>
<p>{t}Page width: 138 mm.{/t}</p>
<p>{t}Page height: 210 mm.{/t}</p>
<p>{t}Number of columns: 2.{/t}</p>
<p>{t}Gutter: 4.2 mm.{/t}</p>
<p>{t}Top, Bottom and Outside margins: 10 mm.{/t}</p>
<p>{t}Untick the option to set all margins the same.{/t}</p>
<p>{t}Inside margin: 12 mm.{/t}</p>
<p>{t}Click Save Preset, and save the settings as "Ndebele". Next time, use this preset to quickly make another new document with the same settings as this one.{/t}</p>
<p>{t}Click OK to create the new document.{/t}</p>

<h2>{t}Setting up the baseline grid{/t}</h2>
<p>{t}All our text will stick to the baseline grid.{/t}</p>
<p>{t}This is a key factor to good typography.{/t}</p>
<p>{t}My leading is 12 points, and I will set up a grid to reflect this.{/t}</p>
<p>{t}Go to menu Edit / Preferences / Grids.{/t}</p>
<p>{t}Start the baseline grid at 0 mm relative to the top margin.{/t}</p>
<p>{t}Increment it every 12 points.{/t}</p>
<p>{t}Press OK. The grid is now set up.{/t}</p>
<p>{t}Optionally, to make it visible, go to menu View / Grids & Guides / Show Baseline Grid.{/t}</p>


<h2>{t}Placing text{/t}</h2>
<p>{t}I am going to show how to place Bible text in InDesign.{/t}</p>
<p>{t}The text is available from Bibledit-Web as OpenDocument files.{/t}</p>
<p>{t}Open the book of Genesis, the version with text and note citations, in OpenOffice.{/t}</p>
<p>{t}Save it as a Microsoft Word 97 / 2000 / XP (.doc) document.{/t}</p>
<p>{t}Create a new document in InDesign.{/t}</p>
<p>{t}Go to menu File / Place, or press Ctrl-D.{/t}</p>
<p>{t}Select the document in MS Word (.doc) format.{/t}</p>
<p>{t}Move the cursor through the document in InDesign. Notice that the cursor shows some of the text to be placed.{/t}</p>
<p>{t}Move the cursor to the corner of the first column where the text will start. Click there. Notice that the first bit of the text will be placed in the first column.{/t}</p>
<p>{t}There is much more text than what fits in just one column. This extra text is not visible. What is visible, though, is a red plus near the end of the first column. This shows that more text is available.{/t}</p>
<p>{t}I would like to place this extra text in the second column.{/t}</p>
<p>{t}Click the Selection Tool or press V. The cursor changes to a selection arrow.{/t}</p>
<p>{t}Select the first column, and then click the red plus near the end of the first column. Notice that the cursor will now show some text.{/t}</p>
<p>{t}Place this text in the second column, in the same way as it was placed in the first column.{/t}</p>
<p>{t}There is still more text than fits in the second column. I estimate that there is enough text to fill many pages.{/t}</p>
<p>{t}I am going to insert an extra page, so that we get more space to place the text.{/t}</p>
<p>{t}To add blank pages, I need to have the Pages palette visible. If the Pages palette is not visible, choose Window > Pages to open the palette.{/t}</p>
<p>{t}In the Pages palette, click Create new page. A new page will be added. This is page 2. Press F12 to close the palette.{/t}</p>
<p>{t}Page 2 shows guides for two columns. I can fill these with text in the manner as described above.{/t}</p>
<p>{t}I can then add as many pages as are needed, and fill each page with text.{/t}</p>

<h2>{t}Span headlines across columns{/t}</h2>
<p>{t}The headline I have in this example is "The first book of Moses called Genesis". I'd like it to span across the two columns.{/t}</p>
<p>{t}Select the left column, and drag the top to make it shorter, so creating space above it.{/t}</p>
<p>{t}Do the same with the right column.{/t}</p>
<p>{t}Select the text "The first book of Moses called Genesis". Cut it to the clipboard.{/t}</p>
<p>{t}Click the Type tool or type Escape T.{/t}</p>
<p>{t}Create a new text box above the two columns. Let it span across the two columns. Estimate the size it needs to be.{/t}</p>
<p>{t}Paste the text into that text box.{/t}</p>
<p>{t}Resize the text box so it looks smart. Then resize both columns so that all looks good.{/t}</p>

<h2>{t}Making text align to the grid{/t}</h2>
<p>{t}Text aligned to the grid is key to good typesetting.{/t}</p>
<p>{t}Select all text you would like to stick to the baseline grid.{/t}</p>
<p>{t}Go to menu Type / Paragraph, or press Alt-Ctrl-T.{/t}</p>
<p>{t}Press the Align to baseline grid button in the bottom right hand corner.{/t}</p>
<p>{t}The leading of the text should be equal to the baseline grid. If the leading of the text is bigger, then it is like as if you have double line spacing.{/t}</p>

<h2>{t}Total page count{/t}</h2>
<p>{t}The publisher may set limits to the number of pages the typeset Bible may contain.{/t}</p>
<p>{t}In this example, we expect an entire Bible, with singable Psalms added as an appendix, to contain no more than 2000 pages. Normal range is 1500 to 1800 pages.{/t}</p>
<br>
<p>{t}We suppose that the singable Psalms take up no more than 200 pages.{/t}</p>
<p>{t}Usually the inclusion of the singable Psalms in a Bible will add about 10% to the number of pages.{/t}</p>
<br>
<p>{t}The Bible will have footnotes and crossreferences, all lumped together into a single textframe at the bottom of each page.{/t}</p>
<p>{t}Let us now measure how many pages the notes are likely to take up.{/t}</p>
<p>{t}Create a new document in InDesign.{/t}</p>
<p>{t}Open the file with all notes in LibreOffice. It is 00_Bible_notes.odt. Save it in the correct format for InDesign.{/t}</p>
<p>{t}Place the text as described above. But I am going to use Autoflow this time. Autoflow will automatically create new text boxes and new page till all text has been placed. This allows us quickly to see how many pages the notes will take up.{/t}</p>
<p>{t}This is how to use Autoflow.{/t}</p>
<p>{t}When you are about the click where you want the text to go, keep the Shift key down.{/t}</p>
<p>{t}I can now roughly see the total number of pages that the notes will take up.{/t}</p>
<p>{t}This is sufficient for an estimate.{/t}</p>
<br>
<p>{t}Let us now find out how many pages the main text body is likely to take up.{/t}</p>
<p>{t}The text is in the file called 00_Bible_text_and_note_citations.odt.{/t}</p>
<p>{t}Place this text and use Autoflow.{/t}</p>
<p>{t}It appears that, on my system, all text cannot be placed at once. It will cut off after some point.{/t}</p>
<p>{t}I will place 01_Genesis_text_and_note_citations.odt instead.{/t}</p>
<p>{t}I can now roughly see the total number of pages that the text of Genesis will take up.{/t}</p>
<p>{t}The size of the whole Bible is about 22 times more than the size of Genesis.{/t}</p>
<br>
<p>{t}The font is of particular influence on the page count. This is not dealt with here.{/t}</p>

<h2>{t}Editing a paragraph style{/t}</h2>
<p>{t}After exporting USFM text to OpenDocument, and placing this text into InDesign, the USFM styles appear in InDesign.{/t}</p>
<p>{t}For example, normal paragraphs usually have style "p", and section heading "s".{/t}</p>
<p>{t}If you like to update a paragraph style, you may update each section heading individually, but this is a lot of work. It is faster to update the style for "s", so that this updates all paragraphs that have this style.{/t}</p>
<p>{t}To update a paragraph style, place the cursor in it, and on the palette choose Paragraph Styles. Right-click the style you want and choose Edit.{/t}</p>

<h2>{t}Running headers{/t}</h2>
<p>{t}The Bible will have running headers. The headers contain the page number near the inside margin. At the right margin it shows book and chapters numbers on that page.{/t}</p>
<br>
<p>{t}Enter the page numbers on the master pages.{/t}</p>
<p>{t}On the Pages palette, double-click the master pages.{/t}</p>
<p>{t}On the left master page, create a text frame, and enter the page number at the inside margin.{/t}</p>
<p>{t}Page numbers can be found in menu Type / Insert Special Character / Marker / Current Page Number.{/t}</p>
<p>{t}On the right master page, create a text frame, and enter the page number at the inside margin too.{/t}</p>
<br>
<p>{t}On page 1, create a new text frame at the top, and put the book and chapter at the outside margin.{/t}</p>
<p>{t}This text frame can be copied to each odd page as it is generated.{/t}</p>
<p>{t}The same applies for page 2, and any subsequent even pages.{/t}</p>
<br>
<p>{t}The page where a book starts normally does not display a page number.{/t}</p>
<p>{t}In order to do that, apply master page [None] to that particular page.{/t}</p>

<h2>{t}Space between drop caps and text{/t}</h2>
<p>{t}It may be visually pleasant to have some space between the drop caps chapter numbers and the text beside it.{/t}</p>
<p>{t}All that is needed is a fixed space after the chapter numbers. Pick any one from a hair space to an em space. The number of characters in drop caps is now increased by one. Set this value in the drop cap settings. All lines after the first will automatically line up.{/t}</p>

<h2>{t}Managing widows or orphans{/t}</h2>
<p>{t}Widows and orphans are words or short lines at the beginning or end of a paragraph, which are left dangling at the top or bottom of a column, separated from the rest of the paragraph.{/t}</p>
<p>{t}There is some disagreement about the definitions of widow and orphan; what one calls a widow the other calls an orphan.{/t}</p>
<p>{t}There are some ways to avoid widows or orphans.{/t}</p>
<p>{t}- Adjusting the spacing between words to produce tighter or looser paragraphs.{/t}</p>
<p>{t}- Adjusting the tracking of the text. This is the overall spacing of the letters in a paragraph or on a line. With a good font in justified paragraphs this can usually be adjusted by up to -25 or +15 without it looking too out of place.{/t}</p>
<p>{t}- Adjusting the hyphenation of words within the paragraph.{/t}</p>
<p>{t}- Forcing a word down onto the next line using a soft return.{/t}</p>

