/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.outerj.daisy.diff.tag.Atom;
import org.outerj.daisy.diff.tag.DelimiterAtom;
import org.outerj.daisy.diff.tag.IAtomSplitter;
import org.outerj.daisy.diff.tag.TagAtom;
import org.outerj.daisy.diff.tag.TextAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagComparator
implements IAtomSplitter {
    private List<Atom> atoms = new ArrayList<Atom>(50);

    public TagComparator(String string) {
        this.generateAtoms(string);
    }

    public TagComparator(StringBuilder stringBuilder) {
        this.generateAtoms(stringBuilder.toString());
    }

    public TagComparator(BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!bl) {
            int n = bufferedReader.read();
            if (n >= 0) {
                stringBuilder.append((char)n);
                continue;
            }
            this.generateAtoms(stringBuilder.toString());
            bl = true;
        }
    }

    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(this.atoms);
    }

    private void generateAtoms(String string) {
        if (this.atoms.size() > 0) {
            throw new IllegalStateException("Atoms can only be generated once");
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' && TagAtom.isValidTag(string.substring(i, string.indexOf(62, i) + 1))) {
                if (stringBuilder.length() > 0) {
                    this.atoms.add(new TextAtom(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                int n = string.indexOf(62, i);
                this.atoms.add(new TagAtom(string.substring(i, n + 1)));
                i = n;
                continue;
            }
            if (DelimiterAtom.isValidDelimiter("" + c)) {
                if (stringBuilder.length() > 0) {
                    this.atoms.add(new TextAtom(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                this.atoms.add(new DelimiterAtom(c));
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            this.atoms.add(new TextAtom(stringBuilder.toString()));
            stringBuilder.setLength(0);
        }
    }

    @Override
    public String substring(int n, int n2) {
        if (n == n2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.atoms.get(i).getFullText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String substring(int n) {
        return this.substring(n, this.atoms.size());
    }

    @Override
    public Atom getAtom(int n) {
        if (n < 0 || n >= this.atoms.size()) {
            throw new IndexOutOfBoundsException("There is no Atom with index " + n);
        }
        return this.atoms.get(n);
    }

    @Override
    public int getRangeCount() {
        return this.atoms.size();
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        TagComparator tagComparator;
        try {
            tagComparator = (TagComparator)iRangeComparator;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return tagComparator.getAtom(n2).equalsIdentifier(this.getAtom(n));
    }

    @Override
    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }
}

