#!/bin/sh

# Check to see whether we use echo -n or echo "\c" to suppress newlines.
case "`echo 'hi there\c'; echo ' '`" in
  *c*) n='-n'; c='';;
  *)   n=''; c='\c';;
esac

# and get java implementation too, Sun JDK or Kaffe
JAVA_IMPL=`java -version 2>&1 | head -1 | cut -f1 -d' '`

if test ! -f freenet-ext.jar; then
  echo freenet-ext.jar not found.  It can be downloaded from
  echo http://freenetproject.org/snapshots/freenet-ext.jar
  echo
  echo $n "Would you like me to download it now? [Y/n] $c"
  read resp
  case "$resp" in
    [Nn]*) exit 0;;
  esac
  wget http://freenetproject.org/snapshots/freenet-ext.jar
  if test ! -f freenet-ext.jar; then
    echo "Sorry, I couldn't download it.  Aborting."
    exit 1
  fi
fi

CLASSPATH=freenet.jar:freenet-ext.jar:$CLASSPATH 
export CLASSPATH
# why are we permanently altering the environment?
# because bourne shell needs it!


if test ! -f seednodes.ref; then
  echo seednodes.ref not found, would you like to download some seeds
  echo from http://hawk.freenetproject.org/~freenet4/seednodes.ref?
  echo $n "[y/N] $c"
  read resp
  case "$resp" in
    [yY]*) wget http://hawk.freenetproject.org/~freenet4/seednodes.ref;;
  esac
fi

if test ! -f freenet.conf; then
  echo It appears that this is your first time running Freenet.  You
  echo should read the README file as it contains important instructions
  echo and advice.
  echo
  echo First we must generate a freenet.conf file.  I will now run
  echo Freenet in configure mode, and it will ask you a number of
  echo questions.  If you don\'t understand the question, hitting "enter"
  echo without typing anything will go with the default which is likely
  echo to be the right thing.
  echo
  sh preconfig.sh
  java freenet.node.Main --config
fi

# if Sun JDK set -server option as suggested on mailing list
#if java -help 2>&1 | grep "[-]server" >/dev/null ;
#then
#  JAVA_ARGS="-server"
#else
#  JAVA_ARGS=""
#fi
# multiple reports that -server option seems to cause crashes
if test /etc/redhat-release
then
  export LD_ASSUME_KERNEL=2.4.1
fi
echo -n "Starting Freenet now: "
nice -n 10 -- java -Xmx128m $JAVA_ARGS freenet.node.Main "$@" &
echo $! > freenet.pid
echo "Done"
