package freenet.transport;
import freenet.*;
import freenet.interfaces.NIOInterface;
import java.io.*;
import java.net.*;
import freenet.support.Logger;
import java.nio.channels.*;


/**
 * this is an actual listener on a nio loop
 * most of the code is stolen from the tcpListener.java
 * usage:
 * this thing registers a socket to a nioloop, then provides a callback
 * method.  That callback method creates a Connection object and delegates it
 * to the appropriate interface.  The interface needs to register with this
 * as well.
 */
public final class tcpNIOListener implements NIOListener {
    private int port;
    private ServerSocket sock;
    private tcpListeningAddress address,addr; //I don't quite get this
    private int designator = -1;
    private boolean dontThrottle;
    private NIOInterface dispatcher;
    private InetAddress bindAddr;
    
    //private SelectionKey skey;
    private SelectorLoop loop;
    public static boolean throttleAll = false;

    private final tcpTransport t;

   public tcpNIOListener(tcpTransport t, tcpListeningAddress addr,
		boolean dontThrottle) throws ListenException {
        this(t, addr, null, -1, dontThrottle);
    }

    tcpNIOListener(tcpTransport t, tcpListeningAddress addr,
                InetAddress bindAddr, int designator, boolean dontThrottle)
	throws ListenException {
        this.t = t;
	this.bindAddr = bindAddr;
	this.designator = designator;
	this.addr = addr;
	address = new tcpListeningAddress(t, bindAddr, designator, port,
					      dontThrottle);
	//
	this.dontThrottle = dontThrottle;
	startListener();
        
    }
    
    /**
     * this method assumes we have passed the necessary arguments
     * at creation time.  Its used for restarting a listener.
     */
    public void startListener() throws ListenException{
    	try {
            port = address.getPort();
	    //sel = Selector.open();
            sock = t.getServerSocketFactory().createServerSocket(addr.getPort(), 50, bindAddr);
            // if addr.port == 0, then the port is set randomly.
            // find out which one we got
            if (port == 0) port = sock.getLocalPort();
            
            
        } catch (IOException e) {
            throw new ListenException(this+": "+e.getMessage());
        }
    }

    public final ListeningAddress getAddress() {
        return address;
    }

    public final void setTimeout(int n) throws IOException {
        sock.setSoTimeout(n);
    }

    public final String toString() {
        return t.getName()+'/'+port;
    }

    /*************** OK HERE WE GO ************/

    public void register(SelectorLoop loop, NIOInterface dispatcher) {
    	this.dispatcher = dispatcher;
    	this.loop = loop;
	loop.register(sock.getChannel(),this);
    }

    public final void close() {
    	try{
		sock.close();
	}catch(IOException e) {}//log something
	loop.unregister(sock);
    }

    public void accept(Socket sock) throws IOException{
    	tcpConnection con = new tcpConnection(t, sock, designator, dontThrottle, throttleAll);
	//call the dispatch method of the interface for this connection.
	dispatcher.acceptConnection(con);
    }


}
