package freenet.support.graph;

/**
 *  represents a 24-bit color
 */
public final class Color
{
    private byte r;
    private byte g;
    private byte b;
    
    /**
     * Create a new color.  red, green, and blue are in the range 0-255.
     */
    public Color(int red, int green, int blue)
    {
        r = (byte) red;
        g = (byte) green;
        b = (byte) blue;
    }
    
    /**
     * get the color value as a an int, in the blue-green-red-reserved format
     * used by windows DIB pallettes
     *
     * bits (msb) 31..24 blue, 23..16 green, 15..8 red, 7..0 (lsb) zero
     */
    int asBGRX()
    {
        int ret = 0;
        
        ret |= (b & 0xFF) << 24;
        ret |= (g & 0xFF) << 16;
        ret |= (r & 0xFF) << 8;
        
        return ret;
    }
    
    byte getRed()
    {
        return r;
    }
    
    byte getBlue()
    {
        return b;
    }
    
    byte getGreen()
    {
        return g;
    }
    
    public boolean equals(Object o) {
	if(o instanceof Color) {
	    Color c = (Color)o;
	    return r == c.r && g == c.g && b == c.b;
	} else return false;
    }
}
