package freenet.support;

import freenet.*;

import java.io.*;
import java.net.*;
import java.util.*;

  ////////////////////////////////////////////////////////////
  // The purpose of all of this gobbledeygook is to
  // keep rude FCPClient implementations from writing
  // to temp files after the requests that
  // own them have been canceled.
  //
  // REDFLAG: Remove once FCPClient implementation
  //          deficiencies have been corrected.
  //

/*
 *  This code is part of fproxy, an HTTP proxy server for Freenet.
 *  It is distributed under the GNU Public Licence (GPL) version 2.  See
 *  http://www.gnu.org/ for further details of the GPL.
 */

/**
 *  Description of the Class
 *
 * @author     ian
 * @created    August 28, 2002
 */
class SpyInputStream extends java.io.FilterInputStream {
  String prefix = "";
  TempFileBucket tfb = null;
  //private final static boolean vociferous = false;

  /**
   *  Description of the Method
   *
   * @param  text  Description of the Parameter
   */
  private final void println(String text) {
    /*if (vociferous) {
      logger.log(this, text, Logger.DEBUGGING);
    }*/
  }


  /**
   *  Description of the Method
   *
   * @exception  IOException  Description of the Exception
   */
  private final void checkValid() throws IOException {
    if (tfb.isReleased()) {
      throw new IOException("Attempt to use a released TempFileBucket: " + prefix);
      //throw new TrackingIOE("Attempt to use a released TempFileBucket: " + prefix);
    }
  }

  /**
   *Constructor for the SpyInputStream object
   *
   * @param  tfb              Description of the Parameter
   * @param  prefix           Description of the Parameter
   * @exception  IOException  Description of the Exception
   */
  public SpyInputStream(TempFileBucket tfb, String prefix) throws IOException {
    super(null);
    InputStream tmpIn = null;
    try {
      this.prefix = prefix;
      this.tfb = tfb;
      checkValid();
      tmpIn = tfb.getRealInputStream();
      in = tmpIn;
    } catch (IOException ioe) {
      try {
        if (tmpIn != null) {
          tmpIn.close();
        }
      } catch (Exception e) {
        // NOP
      }
      throw ioe;
    }
    println("Created new InputStream");
  }


  ////////////////////////////////////////////////////////////
  // FilterInputStream implementation

  /**
   *  Description of the Method
   *
   * @return                          Description of the Return Value
   * @exception  java.io.IOException  Description of the Exception
   */
  public int read() throws java.io.IOException {
    synchronized (tfb) {
      println(".read()");
      checkValid();
      return in.read();
    }
  }


  /**
   *  Description of the Method
   *
   * @param  bytes                    Description of the Parameter
   * @return                          Description of the Return Value
   * @exception  java.io.IOException  Description of the Exception
   */
  public int read(byte[] bytes) throws java.io.IOException {
    synchronized (tfb) {
      println(".read(byte[])");
      checkValid();
      return in.read(bytes);
    }
  }


  /**
   *  Description of the Method
   *
   * @param  bytes                    Description of the Parameter
   * @param  a                        Description of the Parameter
   * @param  b                        Description of the Parameter
   * @return                          Description of the Return Value
   * @exception  java.io.IOException  Description of the Exception
   */
  public int read(byte[] bytes, int a, int b) throws java.io.IOException {
    synchronized (tfb) {
      println(".read(byte[], int, int)");
      checkValid();
      return in.read(bytes, a, b);
    }
  }


  /**
   *  Description of the Method
   *
   * @param  a                        Description of the Parameter
   * @return                          Description of the Return Value
   * @exception  java.io.IOException  Description of the Exception
   */
  public long skip(long a) throws java.io.IOException {
    synchronized (tfb) {
      println(".skip(long)");
      checkValid();
      return in.skip(a);
    }
  }

  /**
   *  Description of the Method
   *
   * @return                          Description of the Return Value
   * @exception  java.io.IOException  Description of the Exception
   */
  public int available() throws java.io.IOException {
    synchronized (tfb) {
      println(".available()");
      checkValid();
      return in.available();
    }
  }


  /**
   *  Description of the Method
   *
   * @exception  java.io.IOException  Description of the Exception
   */
  public void close() throws java.io.IOException {
    synchronized (tfb) {
      println(".close()");
      checkValid();
      in.close();
      if (tfb.streams.contains(in)) {
        tfb.streams.removeElement(in);
      }
    }
  }


  /**
   *  Description of the Method
   *
   * @param  a  Description of the Parameter
   */
  public void mark(int a) {
    synchronized (tfb) {
      println(".mark(int)");
      in.mark(a);
    }
  }


  /**
   *  Description of the Method
   *
   * @exception  java.io.IOException  Description of the Exception
   */
  public void reset() throws java.io.IOException {
    synchronized (tfb) {
      println(".reset()");
      checkValid();
      in.reset();
    }
  }
  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public boolean markSupported() {
    synchronized (tfb) {
      println(".markSupported()");
      return in.markSupported();
    }
  }
}

