package freenet.presentation;

import freenet.*;
import freenet.support.*;
import freenet.support.io.*;
import java.io.*;

public final class FCPRawMessage extends RawMessage {

    /**
     * Constructs a new RawMessage off an FCP Stream
     * @param i An InputStream of decrypted FNP data
     * @param th  The nodes TransportHandler 
     **/
    public FCPRawMessage(InputStream i) 
        throws InvalidMessageException, EOFException {

        Core.logger.log(this, "Reading FCP message", Logger.DEBUG);
        EOFingReadInputStream ris = new EOFingReadInputStream(i);
        fs = new FieldSet();

        try {
            // Read message type
            messageType = ris.readToEOF('\n','\r');

            //            System.out.println(messageType);
            trailingFieldName = fs.parseFields(ris,
                                               '\n', // ends a field
                                               '\r', // ignore before end
                                               '=', // delimits field
                                               '.'); // delimits subset
	    if (trailingFieldName == null) 
	    	throw new EOFException("incomplete fcp message - hopefully");
            setFields(ris);
        /*} catch (EOFException e) {
            if (messageType != null) {
                Core.logger.log(this, 
                                "Stream died while reading message of type: " 
                                + messageType, Logger.ERROR); 
            } else {
                // stream closed without getting a new message
                Core.logger.log(this, "Stream closed", Logger.DEBUG);
            }
            throw e;*/
        } catch (IOException e) {
            throw new EOFException("Could not parse message from stream : " + e);
        } catch(Exception e) {
            Core.logger.log(this, "Exception in RawMessage()", Logger.ERROR);
            e.printStackTrace();
        }
    }

    private void setFields(ReadInputStream in) {
        // Read and set the presentation related fields
        close   = true;
        sustain = true;
        // setting DataLength and trailing
        trailingFieldLength = 0;
        String dlvalue = fs.get("DataLength");
        if (dlvalue != null) {
            trailingFieldLength = Fields.stringToLong(dlvalue);
            //fs.remove("DataLength");
        }
    }

    protected FCPRawMessage(String messageType, boolean close, FieldSet fs,
                            long trailingLength, String trailingName, 
                            DiscontinueInputStream trailing) {
        super(messageType, close, true, fs == null ? new FieldSet() : fs, 
              trailingLength, trailingName, trailing);
    }
    
    // Public Methods

    public void writeMessage(OutputStream out) throws IOException {

        WriteOutputStream writer=new WriteOutputStream(out);
        
        // Output message type
        writer.writeUTF(messageType, '\n');

        // Output tansport options
        if (trailingFieldLength != 0)
            fs.add("Length",Fields.longToString(trailingFieldLength));

        // Output message fields

        fs.writeFields(writer,
                       (trailingFieldName == null ? 
                        "EndMessage" : 
                        trailingFieldName),
                       '\n', // ends a pair
                       '=',  // delimits a pair
                       '.'); // delimits a subset
        // empty writer
        writer.flush();
    }

    public String toString() {
        //return messageType + "\n" + "{Close=" + close + ",Sustain=" + sustain+ 
        //    ",DataLength=" + trailingFieldLength + "," + fs.toString() + "}";
        return messageType + "{Close=" + close + ",Sustain=" + sustain+ 
            ',' + fs + '}';
    }
}

