package freenet.node.states.request;

import freenet.*;
import freenet.node.*;
import java.io.*;

/**
 * This is used to communicate back to the originator of a Request,
 * whether the originator is a node, or an internal or external client.
 */
public interface FeedbackToken {

    /**
     * @param htl          the HTL left at this node
     * @param reason       reason for failing
     * @param fs           other fields to put in message
     * @param unreachable  total no. of send failures
     * @param restarted    total no. of automatic restarts
     * @param rejected     total number of QueryRejected
     */
    void queryRejected(Node n, int htl, String reason, FieldSet fs,
                       int unreachable, int restarted, int rejected)
        throws CommunicationException;

    /**
     * @param millis  the maximum time until the next callback
     */
    void restarted(Node n, long millis)
        throws CommunicationException;
    
    void dataNotFound(Node n, long timeOfQuery)
        throws CommunicationException;
    
    OutputStream dataFound(Node n, Storables sto, long ctLength)
        throws CommunicationException;

    /**
     * @param millis  the maximum time until the next callback
     */
    void insertReply(Node n, long millis)
        throws CommunicationException;

    void storeData(Node n, NodeReference nr, long rate, int hopsSinceReset)
        throws CommunicationException;
}

