package freenet.node.states.announcement;
import freenet.*;
import freenet.node.*;
import freenet.message.*;
/**
 * To make sure we don't get Announcements we have already rejected.
 *
 * @author oskar
 */

public class AnnouncementDone extends AnnouncementState {

    public AnnouncementDone(AnnouncementState st) {
        super(st);
    }

    public String getName() {
        return "Announcement Done";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof NodeAnnouncement)) {
            throw new BadStateException("This announcement has ended");
        } else {
            NodeAnnouncement na = (NodeAnnouncement) mo;
            QueryRejected rf = new QueryRejected(id, na.hopsToLive(), 
                                                 na.otherFields);
            try {
                n.sendMessage(rf, na.getSource(), 0);
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to send back " + rf, n.logger.MINOR);
            }
            return this;
        } 
    }

    public int priority() {
        return EXPENDABLE;
    }

    public void lost(Node n) {
        // good
    }
}
