/* -*- Mode: java; c-basic-indent: 4; tab-width: 4 -*- */
package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.support.*;
import freenet.support.io.*;
import freenet.message.client.*;
import freenet.fs.dir.NativeFSDirectory;
import freenet.transport.tcpAddress;
import freenet.diagnostics.Diagnostics;
import freenet.node.ds.FSDataStore;

import java.util.*;

public class NewInfo extends NewClientRequest {

    public NewInfo(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public final String getName() {
        return "New Client Info";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof ClientInfo))
            throw new BadStateException("expecting ClientInfo");
        FieldSet fs = new FieldSet();
		
		fs.add("EstimatedLoad", Fields.longToString((long)(n.estimatedLoad() * 100)));
		
		fs.add("IsTransient", n.isTransient() ? "true" : "false");
		
		// Place all of these in their own try/catch set, so they the parameters which are
		// available to us will still be returned
		try {
			fs.add("Architecture", System.getProperty("os.arch"));
		} catch (Throwable e) { }
	
		try {
			fs.add("Processors", (String)Runtime.getRuntime().getClass().getMethod("availableProcessors", null).invoke(Runtime.getRuntime(), null));
	    
		} catch (Throwable e) { }
	
		try {
			fs.add("OperatingSystem", System.getProperty("os.name"));
		} catch (Throwable e) { }
	
		try {
			fs.add("OperatingSystemVersion", System.getProperty("os.version"));
		} catch (Throwable e) { }
	
		try {
			fs.add("JavaVendor", System.getProperty("java.vendor.url"));
		} catch (Throwable e) { }
	
		try {
			fs.add("JavaName", System.getProperty("java.vm.name"));
		} catch (Throwable e) { }
	
		try {
			fs.add("JavaVersion", System.getProperty("java.vm.version"));
		} catch (Throwable e) { }
	
		try {
			fs.add("MaximumMemory", (String)Runtime.getRuntime().getClass().getMethod("maxMemory", null).invoke(Runtime.getRuntime(), null));
		} catch (Throwable e) { }
	
		try {
			fs.add("AllocatedMemory", Fields.longToString((long)(Runtime.getRuntime().totalMemory())));
		} catch (Throwable e) { }
	
		try {
			fs.add("FreeMemory", Fields.longToString((long)(Runtime.getRuntime().freeMemory())));
		} catch (Throwable e) { }
	
		fs.add("DatastoreMax", Fields.longToString((long)(n.storeSize*n.storeFile.length)));
		fs.add("DatastoreFree", Fields.longToString((long)(n.dir.available())));
		fs.add("DatastoreUsed", Fields.longToString((long)(n.storeSize*n.storeFile.length - n.dir.available())));
		fs.add("MaxFileSize", Fields.longToString(((FSDataStore)(n.ds)).maxDataSize));
		fs.add("MostRecentTimestamp", Fields.longToString((long)((NativeFSDirectory)n.dir).mostRecentlyUsedTime()));
		fs.add("LeastRecentTimestamp", Fields.longToString((long)((NativeFSDirectory)n.dir).leastRecentlyUsedTime()));
	
		fs.add("RoutingTime", Fields.longToString((long)(n.diagnostics.getValue("routingTime", Diagnostics.MINUTE, Diagnostics.MEAN_VALUE))));
		
		fs.add("AvailableThreads", Fields.longToString(n.availableThreads()));
		fs.add("ActiveJobs", Fields.longToString(n.activeJobs()));

		tcpAddress tcp = Main.getTcpAddress();
		if(tcp!=null) {
			String addr = null;
			try {
				addr = tcp.getHost().getHostAddress();
			} catch (java.net.UnknownHostException e) {
				Core.logger.log(this, "Cannot resolve own address, sending hostname instead",
								Core.logger.ERROR);
				addr = tcp.getValName();
			}
			fs.add("NodeAddress", addr);
			fs.add("NodePort", Fields.longToString((long)tcp.getPort()));
		}
	
		// FIXME: add thread stats stuff here when I work it out ^_^
	
        sendMessage(new NodeInfo(id, fs));
        return null;
    }
}

