package freenet.node.states.FCP;

import freenet.*;
import freenet.message.client.*;
import freenet.node.*;
import freenet.support.Fields;
import java.io.*;

/** This is the FeedbackToken given to the InsertRequestInitiator.
  * @author tavin
  */
public class ClientPutToken extends FCPFeedbackToken {

    private String uri, priv, pub;
    private boolean keyCollision = false;

    ClientPutToken(long id, ConnectionHandler source, String uri) {
        this(id, source, uri, null, null);
    }
    
    ClientPutToken(long id, ConnectionHandler source,
                   String uri, String priv, String pub) {
        super(id, source);
        this.uri  = uri;
        this.priv = priv;
        this.pub  = pub;
    }

    private final FieldSet getFields() {
        FieldSet fs = new FieldSet();
        if (uri  != null) fs.put("URI", uri);
        if (priv != null) fs.put("PrivateKey", priv);
        if (pub  != null) fs.put("PublicKey", pub);
        return fs;
    }
    
    public OutputStream dataFound(Node n, Storables storables, long ctLength)
                                                throws SendFailedException {
        keyCollision = true;
        sendMessage(new KeyCollision(id, getFields()));
        return null;
    }

    public void insertReply(Node n, long millis) throws SendFailedException {
        FieldSet fs = getFields();
        fs.put("Timeout", Fields.longToHex(millis));
        sendMessage(new Pending(id, fs));
    }

    public void storeData(Node n, NodeReference nr, long rate, int hopsSinceReset)
	throws SendFailedException {
        if (!keyCollision)
            sendMessage(new Success(id, getFields()));
    }
}



