package freenet.node.http.infolets;
import freenet.ConnectionHandlerComparator;
import freenet.node.Node;
import freenet.node.http.Infolet;
import freenet.node.http.SimpleAdvanced_ModeUtils;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;

public class OpenConnections extends Infolet {

    private Node node;

    public String longName() {
        return "Open Connections";
    }

    public String shortName() {
        return "ocm";
    }
    
    public boolean visibleFor(HttpServletRequest req){
	return SimpleAdvanced_ModeUtils.isAdvancedMode(req);
    }
    
    public void init(Node n) {
        this.node = n;
    }
    
    public void toHtml(PrintWriter pw, HttpServletRequest req) {
	node.connections.writeHtmlContents(pw,req);
    }
    
    public void toHtml(PrintWriter pw) { //this one should never be called since we have overridden the previous method
	//node.connections.writeHtmlContents(pw,null);
    }
}
