package freenet.node.http;
import junit.framework.TestCase;
import freenet.support.io.NullOutputStream;
import freenet.Core;

import java.io.*;
import java.util.Vector;

public class DistributionTest extends TestCase {

    private String[] freenetResources;
    private String[] freenetExtResources;
    private int oldBS;

    public DistributionTest(String name) {
        super(name);
    }

    public void setUp() {
        try {
            oldBS = Core.blockSize;
            Core.blockSize = 16 * 1024;
            freenetResources = fileList("freenet.files");
            freenetExtResources = fileList("freenet-ext.files");
        } catch (IOException e) {
            fail("Could not read resources: " + e);
        }
    }


    private String[] fileList(String res) throws IOException {
        InputStream in = getClass().getResourceAsStream(res);
        BufferedReader br = 
            new BufferedReader(new InputStreamReader(in, "UTF8"));
        
        Vector v = new Vector(1000);
        String s;
        while ((s = br.readLine()) != null) {
            v.addElement(s);
        }
        String[] rs = new String[v.size()];
        v.copyInto(rs);
        return rs;
    }

    public void testFreenetClasses() {
        try {
            DistributionServlet.writeJarStream(freenetResources, null,
                                               new NullOutputStream());
        } catch (IOException e) {
            fail(e.toString());
        }
    }

    public void testFreenetExtClasses() {
        try {
            DistributionServlet.writeJarStream(freenetExtResources, null,
                                               new NullOutputStream());
        } catch (IOException e) {
            fail(e.toString());
        }
    }

    public void tearDown() {
        freenetResources = null;
        freenetExtResources = null;
        Core.blockSize = oldBS;
    }


}
