package freenet.message.client.FEC;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import freenet.message.client.ClientMessage;
import freenet.support.Fields;

/** Message to make a list of SegmentHeaders from
 *  SplitFile metadata.
 */
public class FECSegmentSplitFile extends ClientMessage {

    public static final String messageName = "FECSegmentSplitFile";

    // From wire
    public FECSegmentSplitFile(ConnectionHandler source, RawMessage raw) {
        super(source, raw, true);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing FECSegmentSplitFile message.")
            : (State) new NewFECSegmentSplitFile(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}





