package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.support.*;

/**
 * QueryRestarted messages are sent when the Query is restarted do to no
 * response coming back from a node, or bad data being discovered etc.
 * Since the scheduled time is relative to the hops to live, this ensures
 * that even on an error, the query is only restarted at the "deepest" possible
 * node.
 *
 * @author oskar
 */

public class QueryRestarted extends NodeMessage {

    public static final String messageName = "QueryRestarted";

    public QueryRestarted(ConnectionHandler source, 
                          RawMessage m) throws InvalidMessageException {
	super(source, m);
    }

    public QueryRestarted(long idnum) {
	super(idnum, null);
    }

    
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	//raw.messageType="QueryRestarted";
	raw.trailingFieldName="EndMessage";
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

} 







