/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the DataRequest message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.node.states.FNP.NewDataRequest;
import freenet.support.*;
//import java.net.*;

public class DataRequest extends Request {

    public static final String messageName = "DataRequest";
    
    public DataRequest(long idnum, long htl, Key key, NodeReference ref) {
	super(idnum, htl, key, ref);
    }

    public DataRequest(long idnum, long htl, Key key, NodeReference ref,
                       FieldSet otherFields) {
	super(idnum, htl, key, ref, otherFields);
    }

    public DataRequest(ConnectionHandler source, RawMessage raw) throws InvalidMessageException {
	super(source, raw);
    }
  	
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	//raw.messageType="DataRequest";
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    public State getInitialState() {
	stateTime = System.currentTimeMillis();
	if(receivedTime > 1000*1000*1000) {
	    Core.diagnostics.occurrenceContinuous("messageInitialStateTime", 
						  stateTime - receivedTime);
	}
	return new NewDataRequest(id);
    }

}


