/*
   This code is part of the Java Adaptive Network Client by Ian Clarke. 
   It is distributed under the GNU Public Licence (GPL) version 2.  See
   http://www.gnu.org/ for further details of the GPL.
*/


/**
 * This is the DataInsert message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 * @author oskar
 **/

package freenet.message;

import java.io.*;
import freenet.*;
import freenet.node.*;
import freenet.node.ds.KeyCollisionException;
import freenet.node.states.data.ReceiveData;
import freenet.support.*;
import freenet.support.io.*;

public class DataInsert extends DataSend {

    public static final String messageName = "DataInsert";

    public DataInsert(long idnum, FieldSet otherfields, long length)
	throws BadAddressException {
	super(idnum, otherfields, null, length);
    }

    public DataInsert(long idnum, FieldSet otherfields, 
		      DiscontinueInputStream data, long length)
	throws BadAddressException {
	super(idnum, otherfields, data, length);
    }


    public DataInsert(ConnectionHandler source, RawMessage raw)
	throws InvalidMessageException, BadAddressException {
	super(source, raw);
    }
    
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	//raw.messageType="DataInsert";
	//	System.out.println(raw.toString());
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }
    
    // index later
    //public ReceiveData cacheData(Node n, Key searchKey) 
    //        throws IOException, DataNotValidIOException, KeyCollisionException {
    //    return super.cacheData(n, searchKey, false);
    //}
}


