/* -*- Mode: java; c-basic-indent: 4; tab-width: 4 -*- */
package freenet.interfaces;

import freenet.transport.TCP;
import freenet.Connection;
import freenet.ListeningAddress;
import freenet.ListenException;
import freenet.BadAddressException;
import java.net.InetAddress;
import freenet.config.Params;
import freenet.transport.ReadSelectorLoop;
import freenet.transport.WriteSelectorLoop;
import freenet.transport.NIOReader;
import freenet.transport.NIOWriter;
import freenet.transport.tcpConnection;
import freenet.Core;
import freenet.support.Logger;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.SelectableChannel;
import java.util.Vector;

public class TestLocalNIOInterface extends BaseLocalNIOInterface {
    
    public final ReadSelectorLoop rsl;
    public final WriteSelectorLoop wsl;
    
    public TestLocalNIOInterface(ListeningAddress listenAddr, 
				 ReadSelectorLoop rsl, 
				 WriteSelectorLoop wsl,
				 String allowedHosts, 
				 int lowRunningConnections,
				 int highRunningConnections) 
	throws ListenException {
	super(listenAddr, allowedHosts, lowRunningConnections,
	      highRunningConnections);
	this.rsl = rsl;
	this.wsl = wsl;
    }
    
    protected void handleConnection(Connection conn) {
	Core.logger.log(this, "Received connection", Logger.DEBUG);
	if(!(conn instanceof tcpConnection))
	    throw new IllegalArgumentException();
	Core.logger.log(this, "tcpConnection", Logger.DEBUG);
	Socket sock;
	try {
		sock = ((tcpConnection)conn).getSocket();
	} catch (IOException e) { return; }
	SocketChannel sc = sock.getChannel();
	Core.logger.log(this, "Got channel: "+sc, Logger.DEBUG);
	try {
	    sc.configureBlocking(false);
	} catch (IOException e) {
	    Core.logger.log(this, "Cannot configure nonblocking mode on SocketChannel!", Logger.ERROR);
	}
	rsl.register(sock, new TestNIOCallback(sc));
	Core.logger.log(this, "Registered channel", Logger.DEBUG);
    }
    
    long connectionCounter = 0;
    Object ccSync = new Object();
    
    public class TestNIOCallback implements NIOReader,NIOWriter {
	long connectionNumber;
	SelectableChannel sc;
	
	Vector sending = new Vector();
	
	public TestNIOCallback(SelectableChannel sc) {
	    synchronized(ccSync) {
		connectionCounter++;
		connectionNumber = connectionCounter;
	    }
	    this.sc = sc;
	}
	
	public int process(ByteBuffer b) {
	    Core.logger.log(TestLocalNIOInterface.this,
			    "Got buffer", Logger.DEBUG);
	    if(b == null) return 1;
	    int len = b.remaining();
	    if(len <= 0) return 1;
	    byte[] buf = new byte[len];
	    b.get(buf);
	    String s = new String(buf);
	    Core.logger.log(TestLocalNIOInterface.this, 
			    "Connection "+connectionNumber+": "+
			    s.length()+": " + s, Logger.DEBUG);
	    sendPacket(buf);
	    sendPacket(buf);
	    sendPacket(buf);
	    return 1;
	}
	
	public void sendPacket(byte[] buf) {
	    Core.logger.log(this, "Sending packet of length "+buf.length,
			    Logger.DEBUG);
	    try {
		if(!wsl.send(buf, sc, this)) {
		    Core.logger.log(this, "Failed send", Logger.DEBUG);
		    sending.add(buf);
		}
	    } catch (IOException e) {
		Core.logger.log(this, "Got IOException sending data",
				e, Logger.ERROR);
	    }
	}
	
	public void configRSL(ReadSelectorLoop rsl) {};
	public void configWSL(WriteSelectorLoop wsl) {};
	public void closed() {};
	public void jobDone(int size, boolean status) {
	    Core.logger.log(this, "Send complete: "+size+", "+status,
			    Logger.DEBUG);
	    if(status) {
		if(sending.size() > 0) {
		    byte[] buf = (byte[])(sending.remove(0));
		    try {
			if(!wsl.send(buf, sc, this)) {
			    Core.logger.log(this, "Could not send data in jobDone handler!", Logger.ERROR);
			} else {
			    String s = "Hahahahahahaha\n";
			    sending.add(s.getBytes());
			}
			Core.logger.log(this, "Sent some data in jobDone",
					Logger.DEBUG);
		    } catch (IOException e) {
			Core.logger.log(this, "Sending data failed: "+e, e,
					Logger.ERROR);
		    }
		}
	    }
	}
    }
}
