package freenet.interfaces;

import freenet.*;
import freenet.node.*;
import freenet.client.cli.*;
import freenet.config.*;
import freenet.support.io.ReadInputStream;
import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * Plaything.
 *
 * @author oskar
 */
public class TerminalService implements Service {

    private final Node node;
    private final CLIInternalClient client;

    public TerminalService(Node node) {
        this.node   = node;
        this.client = new CLIInternalClient(node);
    }

    public void setInitFirst(boolean b) { // FIXME?
    }
    
    public boolean needsThread() {
	return true;
    }
    
    public final String name() {
        return "InternalClient terminal";
    }

    public final Config getConfig() {
        return null;
    }

    public final void init(Params p, String serviceName) {
    }

    public void handle(Connection c) {
        try {
            ReadInputStream in = 
                new ReadInputStream(new BufferedInputStream(c.getIn()));
            PrintStream out = 
                new PrintStream(new BufferedOutputStream(c.getOut()), true);
            
            String s;
            while ((s = in.readTo('\n','\r')) != null) {
                try {
                    String[] ss = getCommands(s);
                    Params p = new Params(CLI.options.getOptions());
                    p.readArgs(ss);
                    (new CLI(p, client, node.logger, in, out, out)).execute();
                } catch (CLIException e) {
                    out.println("CLI Error:  " + e);
                }
            }
        } catch (IOException e) {
            node.logger.log(this, "IOError : " + e,
                            node.logger.MINOR);
        } finally {
            c.close();
        }
    }

    public static String[] getCommands(String command) {
        Vector v = new Vector();
        StringTokenizer st = new StringTokenizer(command, "\" ", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(" ")) {
            } else if (s.equals("\"")) {
                v.addElement(st.nextToken("\""));
                if (st.hasMoreTokens()) {
                    s = st.nextToken("\" "); // reset and eat endquote token
                    if (!s.equals("\"")) { // impossible?
                        throw new Error("I was expected endquote after quote");
                    }
                }
            } else
                v.addElement(s);
        }
        String[] ss = new String[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public void starting() {}; // No node-load-time init
}

