package freenet.fs;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

/**
 * A ramdisk.
 *
 * @author oskar
 */

public class RAMStorage implements Storage {

    public byte[] data;

    public RAMStorage(int size) {
        data = new byte[size];
    }

    public long size() {
        return data.length;
    }

    public long truncation() {
        return 0;
    }

    public InputStream getInputStream(long start, long end) {
        return new SectionInputStream((int) start, (int) end);
    }

    public class SectionInputStream extends InputStream {

        public int current;
        public int end;

        public SectionInputStream(int current, int end) {
            this.current = current;
            this.end = end;
        }

        public int available() {
            return end - current;
        }

        public int read() {
            if (current <= end) {
                current++;
                return data[current - 1] & 0xff;
            } else
                return -1;
        }

        public int read(byte[] b, int off, int len) {
            len = Math.min(end - current + 1, len);
            if (len <= 0)
                return -1;
            else {
                System.arraycopy(data, current, b, off, len);
                current += len;
                return len;
            }
        }
    }

    public OutputStream getOutputStream(long start, long end) {
        return new SectionOutputStream((int) start, (int) end);
    }

    public class SectionOutputStream extends OutputStream {
        public int current;
        public int end;
        
        public SectionOutputStream(int current, int end) {
            this.current = current;
            this.end = end;
        }

        public void write(int i) throws IOException {
            if (current > end)
                throw new IOException("Overwrote RAMStorage section.");
            data[current] = (byte) i;
            current++;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > (end - current + 1)) 
                throw new IOException("Overwrote RAMStorage section: " +
                                      len + " at " + current + " of " +
                                      end);
            System.arraycopy(b, off, data, current, len);
            current += len;
        }

    }







}
