package freenet.diagnostics;
import freenet.support.*;
import java.util.Enumeration;
/**
 * A filter for for the BasicDoublyLinkedList in freenet.support.
 *
 * @author oskar
 */

class LinkedEventList implements EventList {

    DoublyLinkedList ll;

    public void open(RandomVar rv) {
    }

    public void close() {
    }

    public LinkedEventList() {
        ll = new DoublyLinkedListImpl();
    }

    public LinkedEventList(String s) {
        this();
    }

    public String restoreString() {
        return "null";
    }

    public void addFirst(VarEvent ve) {
        ll.unshift(ve);
    }

    public void addLast(VarEvent ve) {
        ll.push(ve);
    }

    public void insertNext(VarEvent at, VarEvent ve) {
        ll.insertNext(at, ve);
    }

    public VarEvent getFirst() {
        return (VarEvent) ll.head();
    }

    public VarEvent getLast() {
        return (VarEvent) ll.tail();
    }

    public VarEvent removeFirst() {
        return (VarEvent) ll.shift();
    }
    
    public Enumeration elements() {
        return ll.elements();
    }

    public Enumeration reverseElements() {
        return ll.reverseElements();
    }
}
