package freenet.diagnostics;
import freenet.support.EmptyEnumeration;

public class GraphRangeDiagnosticsFormat implements DiagnosticsFormat
{
    private final int period;
    private final int type;
    private GraphRange r; 
    
    public GraphRangeDiagnosticsFormat(int period, int type)
    {
        this.period = period;
        this.type = type;
        
        r = null;
    }
    
    public String formatStart(DiagnosticsCategory dc) {return "";}

    public String formatEnd(DiagnosticsCategory dc) {return "";}

    public String format(RandomVar rv)
    {
        EventList el = rv.getEvents(period);
        if (el == null) {
            // hack to get rid of NPE. Original author may wish to revise.
            // - oskar
            r = new GraphRange(new EmptyEnumeration(), 
                               Diagnostics.NUMBER_OF_EVENTS);
        } else {
            el.open(rv);
        
            r = new GraphRange(el.elements(), type);
        
            el.close();
        }
        return "";
    }

    public GraphRange getRange()
    {
        return r;
    }
}
