package freenet.diagnostics;
import freenet.support.*;
import freenet.Core;
import java.io.*;
import java.util.Enumeration;

/**
 * Like LinkedEventList, but saves the data to a file between sessions.
 */
public class FileEventList implements EventList {

    private DoublyLinkedList ll;
    private File f;

    public static boolean isCached(String dir, String varName, long type) {
        return (new File(dir + File.separator + varName)).exists() && 
            (new File(dir + File.separator + varName, 
                      Long.toString(type))).exists();
    }

    public FileEventList(String dir, String varName, long type) 
        throws IOException {
        //        System.out.println("New filevenetlist");
        File p = new File(dir + File.separator + varName);
        if (!p.exists()) {
            p.mkdirs();
        }
        f = new File(dir + File.separator + varName, Long.toString(type));
        if (!f.exists())
            ll = new DoublyLinkedListImpl();
    }

    /**
     * Contructor for when restoring.
     */
    public FileEventList(String path) {
        f = new File(path);
    }

    public String restoreString() {
        return f.getName();
    }

    public synchronized void open(RandomVar rv) {
        if (ll == null)
            ll = read(f, rv);
    }

    public synchronized void close() {
        write(ll, f);
        ll = null;
    }

    public void addFirst(VarEvent ve) {
        if (ll == null) throw new RuntimeException("Open not called.");
        ll.unshift(ve);
    }

    public void addLast(VarEvent ve) {
        if (ll == null) throw new RuntimeException("Open not called.");
        ll.push(ve);
    }

    public void insertNext(VarEvent at, VarEvent ve) {
        if (ll == null) throw new RuntimeException("Open not called.");
        ll.insertNext(at, ve);
    }

    public VarEvent getFirst() {
        if (ll == null) throw new RuntimeException("Open not called.");
        return (VarEvent) ll.head();
    }

    public VarEvent getLast() {
        if (ll == null) throw new RuntimeException("Open not called.");
        return (VarEvent) ll.tail();
    }

    public VarEvent removeFirst() {
        if (ll == null) throw new RuntimeException("Open not called.");
        return (VarEvent) ll.shift();
    }
    
    public Enumeration elements() {
        if (ll == null) throw new RuntimeException("Open not called.");
        return ll.elements();
    }

    public Enumeration reverseElements() {
	if (ll == null) throw new RuntimeException("Open not called.");
        return ll.reverseElements();
    }

    private boolean write(DoublyLinkedList ll, File f) {
        try {
            DataOutputStream out = new 
                DataOutputStream(new 
                    BufferedOutputStream(new 
                        FileOutputStream(f)));

            for (Enumeration e = ll.elements() ; e.hasMoreElements() ;) {
                ((VarEvent) e.nextElement()).write(out);
                out.writeBoolean(e.hasMoreElements());
            }
            out.flush();
            out.close();
            return true;
        } catch (IOException e) {
            Core.logger.log(this, 
                            "Failed to write data to disk, not overwriting", 
                            e, Core.logger.ERROR);
            return false;
        }
    }

    private DoublyLinkedList read(File f, RandomVar to) {
        try {
            DataInputStream in = new
                DataInputStream(new 
                    BufferedInputStream(new
                        FileInputStream(f)));
            boolean more;
            DoublyLinkedList ll = new DoublyLinkedListImpl();
            do {
                ll.push(to.readEvent(in));
            } while (in.readBoolean());

            in.close();
            return ll;
        } catch (IOException e) {
            Core.logger.log(this, 
                            "Failed to read data from disk, using empty file.",
                            e, Core.logger.ERROR);
            return new DoublyLinkedListImpl();
                
        }

    }
}




