package freenet.client.http;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

import freenet.node.Node;

import freenet.support.servlet.HtmlTemplate;

/**
 * The ImageServlet serves up images stored in the freenet.jar file
 * for other servlets. e.g. NodeInfoServlet.
 * <p>
 * Images are loaded from the path set by 
 * freenet.support.servlet.HTMLTemplate.TEMPLATEDIR.
 **/
public class ImageServlet extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException {

        String path = req.getPathInfo();
        returnImage(resp, path);
        resp.flushBuffer();
    }

    /**
     *  Description of the Method
     *
     * @param  resp   Description of the Parameter
     * @param  image  Description of the Parameter
     */
    public void returnImage(HttpServletResponse resp, String image) {
        try {
            // Determine and set content-type
            if (image.toLowerCase().endsWith(".png")) {
                resp.setContentType("image/png");
            }
            if (image.toLowerCase().endsWith(".gif")) {
                resp.setContentType("image/gif");
            }
            if (image.toLowerCase().endsWith(".jpg") || image.toLowerCase().endsWith(".jpeg")) {
                resp.setContentType("image/jpeg");
            }
            InputStream imagenbIS = this.getClass().getResourceAsStream(HtmlTemplate.TEMPLATEDIR
                                                                        + "images/" + image);
            if (imagenbIS == null) {
                Node.logger.log(this, "Can't find image " + image, Node.logger.ERROR);
		resp.sendError(404);
		return;
            }
	    resp.addDateHeader("Expires", System.currentTimeMillis()+
			       24*3600*1000);
            BufferedInputStream imageIS = new BufferedInputStream(imagenbIS);
            OutputStream imageOS = resp.getOutputStream();
            int r = imageIS.read();
            while (r != -1) {
                imageOS.write(r);
                r = imageIS.read();
            }
        } catch (Exception e) {
            Node.logger.log(this, "Failed to read/write image", e, Node.logger.ERROR);
        }
    }
    
    static final private long loadTime = System.currentTimeMillis();

    protected long getLastModified(HttpServletRequest req) {
	return loadTime;
    }

}

