/* Copyright (C) 2012 Carlos Pais 
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "changecolor_editor_widget.h"

#include "changecolor.h"

ChangeColorEditorWidget::ChangeColorEditorWidget(QWidget *parent) :
    ActionEditorWidget(parent)
{
    mObjectsComboBox = new QComboBox(this);
    mColorButton = new ColorPushButton(this);
    mOpacitySlider = new QSlider(Qt::Horizontal, this);
    mChangeObjectColorCheckBox = new QCheckBox(this);
    mChangeObjectColorCheckBox->setChecked(true);
    mChangeObjectBackgroundColorCheckBox = new QCheckBox(this);
    mOpacitySlider->setMinimum(0);
    mOpacitySlider->setMaximum(255);
    mChangeColorAction = 0;

    beginGroup(tr("Change color editor"));
    beginSubGroup(tr("Object"), mObjectsComboBox);
    appendRow(tr("Object"), mChangeObjectColorCheckBox);
    appendRow(tr("Object's background"), mChangeObjectBackgroundColorCheckBox);
    endGroup();
    appendRow(tr("Color"), mColorButton);
    appendRow(tr("Opacity"), mOpacitySlider);
    endGroup();
    resizeColumnToContents(0);

    connect(mObjectsComboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(onObjectChanged(int)));
    connect(mChangeObjectColorCheckBox, SIGNAL(toggled(bool)), this, SLOT(onChangeObjectColorToggled(bool)));
    connect(mChangeObjectBackgroundColorCheckBox, SIGNAL(toggled(bool)), this, SLOT(onChangeObjectBackgroundColorToggled(bool)));
    connect(mColorButton, SIGNAL(colorChosen(const QColor&)), this, SLOT(onColorChosen(const QColor&)));

}

void ChangeColorEditorWidget::updateData(Action * action)
{
    mChangeColorAction = qobject_cast<ChangeColor*>(action);
    if (! mChangeColorAction)
        return;

    mObjectsComboBox->clear();

    if (mChangeColorAction->sceneObject()) {
        mObjectsComboBox->addItem(mChangeColorAction->sceneObject()->objectName());
        mObjects.append(mChangeColorAction->sceneObject());
    }

    QList<Object*> objects = ResourceManager::resources();

    foreach(Object* obj, objects) {
        if (obj == mChangeColorAction->sceneObject())
            continue;

        if (obj) {
            mObjectsComboBox->addItem(obj->objectName());
            mObjects.append(obj);
        }
    }

    if (! mChangeColorAction->sceneObject() && ! mObjects.isEmpty())
        mChangeColorAction->setSceneObject(mObjects[0]);

    mColorButton->setColor(mChangeColorAction->color());
    mOpacitySlider->setValue(mChangeColorAction->opacity());

}

void ChangeColorEditorWidget::onColorChosen(const QColor & color)
{
    if (mChangeColorAction) {
        mChangeColorAction->setColor(color);
    }
}

void ChangeColorEditorWidget::onObjectChanged(int index)
{
    if (! mChangeColorAction || index < 0 || index >= mObjects.size())
        return;

    mChangeColorAction->setSceneObject(mObjects[index]);

}

void ChangeColorEditorWidget::onChangeObjectColorToggled(bool checked)
{
    if (! checked && !mChangeObjectBackgroundColorCheckBox->isChecked())
        mChangeObjectColorCheckBox->setChecked(true);

    if(mChangeColorAction)
        mChangeColorAction->setChangeObjectColor(mChangeObjectColorCheckBox->isChecked());
}

void ChangeColorEditorWidget::onChangeObjectBackgroundColorToggled(bool checked)
{
    if (! checked && ! mChangeObjectColorCheckBox->isChecked())
        mChangeObjectBackgroundColorCheckBox->setChecked(true);

    if(mChangeColorAction)
        mChangeColorAction->setChangeObjectBackgroundColor(mChangeObjectBackgroundColorCheckBox->isChecked());
}
