/*
 * beerun.c: Statemachine zu den Fahrablaeufen
 *
 */

/*  BSD-License:

Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include <stdlib.h>         //
//#include "systemtimer.h"
#include <leds.h>           // LED-Steuerung
#include <feelers.h>        // Sensorik
//#include <rc5rcv.h>         // RC5 reveiver (IR remote control)
#include "running.h"         // Fahrsteuerung

#define BEERUN_INIT_TIME  (10)

// Hardware initialisieren
void BeeRun_Init(void)
{
  LEDS_INIT();
//  Feelers_Init(BeeRun_FeelersEvent);
  Feelers_Init(NULL);
//  Running_Init(BeeRun_RunningEvent);
  Running_Init(NULL);
//  RC5Rcv_CheckAndInit();
      // RC5-Code auswerten
//      RC5Rcv_ReadCode();
}

void BeeRun_StateMachine(void)
{
  static enum
  {
    BeeRun_State_Init = 1,
    BeeRun_State_Stopped,
    BeeRun_State_StoppedWaitIR,
    BeeRun_State_Running,
    BeeRun_State_RunningWaitIR,
    BeeRun_State_TurnLeft,
    BeeRun_State_TurnRight,
  }
  BeeRun_States;
  int16_t BeeRun_InitTime;
  
  // Statemachine
  switch (BeeRun_States)
  {
  case BeeRun_State_Init:
    // Wait a startup time befor initializing
    BeeRun_InitTime = SystemTimer_GetOffset(BEERUN_INIT_TIME);
    while (!SystemTimer_IsExpired(BeeRun_InitTime));
    // Initialisierung und Uebergang zum State Angehalten (stopped)
    BeeRun_Init();
    BeeRun_States = BeeRun_State_Stopped;
    break;
  case BeeRun_State_Stopped:
    // RC5 receiving
//    RC5Rcv_Start();
    BeeRun_States = BeeRun_State_StoppedWaitIR;
    break;
  case BeeRun_State_StoppedWaitIR:
    // Tasten abfragen
    // gegebenenfalls Status wechseln
    if (    (Feelers_Read_KeysChanged())
         && GET_BIT(Feelers_Read_KeysState(), IO_FEELERS_BIT_L_BACK)
         && GET_BIT(Feelers_Read_KeysState(), IO_FEELERS_BIT_R_BACK) )

//    if (RC5Rcv_CodeSampled())

    {
      Feelers_Write_KeysChanged(0);
      // RC5-Code auswerten
//      RC5Rcv_ReadCode();
      // Motoren starten
      Running_Gerade();
      BeeRun_States = BeeRun_State_Running;
    }
    break;
  case BeeRun_State_Running:
    // RC5 receiving
//    RC5Rcv_Start();
    BeeRun_States = BeeRun_State_RunningWaitIR;
    break;
  case BeeRun_State_RunningWaitIR:
    // Tasten abfragen
    // gegebenenfalls Status wechseln
    if (Feelers_Read_KeysChanged())
    {
      Feelers_Write_KeysChanged(0);
      if (GET_BIT(Feelers_Read_KeysState(), IO_FEELERS_BIT_L_FORW))
      {
        Running_WendenNachLinks();
      }
      else if (GET_BIT(Feelers_Read_KeysState(), IO_FEELERS_BIT_R_FORW))
      {
        Running_WendenNachRechts();
      }
    }
    // Received IR remote control?
//    else if (RC5Rcv_CodeSampled())
//    {
//      Running_Zurueck();
//      BeeRun_States = BeeRun_State_Stopped;
//    }
    // Wenn einer oder beide Motoren stehen, anhalten
    else if (  (Running_GetMotorPID_Event() == MotorPID_Event_L_Blocked)
            || (Running_GetMotorPID_Event() == MotorPID_Event_R_Blocked)
            || (Running_GetMotorPID_Event() == MotorPID_Event_LR_Blocked) )
    {
      // Motoren anhalten
      Running_Stopp();
      BeeRun_States = BeeRun_State_Stopped;
    }
    break;
  default:
    // Ein anderer State ist unzulaessig -> Neu initialisieren
    BeeRun_States = BeeRun_State_Init;
    break;
  }
}

