/*  BSD-License:

Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*! @file    feelers.h
 *  @brief   Key debouncing at the "feelers"
 *  @author  Matthias Bunte (m_bunte@arcor.de)
 *  @date    2010-03-07
 */

#ifndef _BEELIB_FEELERS_H_
#define _BEELIB_FEELERS_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

// Typ fuer einen Zeiger auf die Eventfunktion, die bei einer Aenderung des
// Tastenzustandes aufgerufen wird.
typedef void (*pFeelers_KeysChanged_Fkt_t)(uint8_t *, uint8_t);

// Initialisierung der Feelers-Sensoren.
// Die Pullups werden durch Aufruf dieser Funktion aktiviert.
// Parameter ist die Eventfunktion, die bei einer Tastenaenderung aufzurufen ist
//
// Falls die Parameter gepollt werden sollen, kann an dieser Stelle "NULL" ein-
// gesetzt werden und mit den "Read"- und "Write"-Funktionen gearbeitet werden.
//
void Feelers_Init(pFeelers_KeysChanged_Fkt_t pFeelers_NewKeysChanged_Fkt);

// Initialisierungszustand auslesen
uint8_t Feelers_Initialized(void);

// Pruefe, ob schon initialisiert wurde und wenn nicht, initialisiere
#define Feelers_CheckAndInit(P_FEELERS_NEWKEYSCHANGED) do { \
  if (!Feelers_Initialized()) Feelers_Init(P_FEELERS_NEWKEYSCHANGED); \
} while (0)

// Liest den aktuellen Tastenzustand
uint8_t Feelers_Read_KeysState(void);

// Liest, welche Tasten geaendert sind.
//
// Die Bits dieser Variable werden von dem Feelers-Paket nur gesetzt, das
// zuruecksetzen muss in der Applikation durch die "Write"-Funktion erfolgen.
uint8_t Feelers_Read_KeysChanged(void);

// Schreibt die aktualisierten Tastenaenderungen zurueck.
//
// Hier duerfen die mit der "Read_KeysChanged"-Funktion ausgelesenen Bits nur
// zurueckgesetzt werden, wenn die Auswertung der Tastenaenderung abgeschlossen
// ist.
void Feelers_Write_KeysChanged(uint8_t KeysChanged);

// Entprellungsfunktion, durch das Timersystem aufzurufen.
void Feelers_Entprellung(uint16_t dummy);

#ifdef __cplusplus
} // extern "C"
#endif


#endif // _BEELIB_FEELERS_H_

