<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "config/config.inc.php";
include "inc/functions.inc.php";


session_start();

if (isset($_REQUEST['logoff'])) {
	unset ($_SESSION);
	session_destroy();
	session_start();
}



// SITE LANGUAGE -----------------------------------------------------------
if (isset($_REQUEST['language_id'])) {
	$_SESSION['language_id'] = $_REQUEST['language_id'];
}
elseif (!isset($_SESSION['language_id'])){
    $_SESSION['language_id'] = $c_node['node']['language']['default'];
}


// SETUP ERROR HANDLING ---------------------------------------------------
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE ------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE -----------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Date.class.php');
$date = new Date();


//SETUP FILE ----------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, $c_node['file']);


// SETUP TEMPLATE ------------------------------------------------------------
$template_path = $c_node['dir']['template_path'];
require_once($c_node['dir']['class_path'] . 'Template.class.php');
$tpl = & new Template($template_path); // This is the outter template
$body = & new Template($template_path); // This is the inner template


//SETUP Menu ----------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Menu.class.php');
$menu = new Menu($db, $c_node['menu']);
$menu->config_menu = $c_node['menu'];
$menu->language_id = $_SESSION['language_id'];
$tpl->menu = $menu;


// SETUP LANGUAGE -----------------------------------------------------------
$languagePath = "language/";
$languageFile = $c_node['node']['language']['pack'][$_SESSION['language_id']][1] . "_common.lang.php";

require_once($languagePath . $languageFile);

// setup a default language local for php
setlocale(LC_ALL,$c_node['node']['language']['pack'][$_SESSION['language_id']][0]);


// SETUP USER CLASS --------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db);
if (isset($_SESSION['user_id'])) {
	$user->user_id = $_SESSION['user_id'];
}
$user->language_arr = $c_node['node']['language'];


// SETUP ITEM CLASS --------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Item.class.php');
$item = new Item($db, $date);
$item->language_id = $_SESSION['language_id'];

if (isset($_REQUEST['item_id'])) {
    $item->item_id = $_REQUEST['item_id'];
}
elseif (isset($_REQUEST['page'])) {
    $item->item_wiki_page = $_REQUEST['page'];
}
elseif (isset($_REQUEST['category'])) {
    $item->category_id = $_REQUEST['category'];
}

// SETUP WIKI CLASS --------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();

$wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=');
$wiki->setRenderConf('xhtml', 'swf', 'base', 'get_file.php?file=');
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', "index.php?page=");

if ($user->checkPermission($c_node['permission']['edit_item'])) {
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', "admin.php?add_item=1&page=");
}
else {
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', "#");
}




	
	





// SETUP POST VARS --------------------------------------------------------
if (isset($_POST)) {
	$frmdata = $_POST;
}


// DICTIONARY ---------------------------------------------------------------
// Is the config set to allow spell checking?
if (!empty($c_node['node']['aspell']['command'])) {
    $body->set('allow_spellcheck', 1);
}


?>
