<?php

// LICENSE -----------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.


// RELEASE NOTES ---------------------------------------------------------
$c_node['release']['version'] = 		"0.1.6";
$c_node['release']['release_date'] = 	"06-19-2005"; // MM-DD-YYYY
$c_node['release']['install_date'] = 	""; // MM-DD-YYYY


//DATABASE CONFIGURATION --------------------------------------------------
$c_node['db']['driver'] = 				"mysql";
$c_node['db']['host'] = 				"localhost";
$c_node['db']['user'] = 				"your_user_name";
$c_node['db']['pass'] = 				"your_password";
$c_node['db']['db']=	 				"your_database_name";
$c_node['db']['prefix'] =	 			"beacon";


// PHP CONFIGURATION -----------------------------------------------------
//ini_set('error_reporting', E_ALL); 	// error handling in dev environment.
ini_set('error_reporting', 0);


// DIRECTORY CONFIGURATION ------------------------------------------------
$c_node['dir']['template_path'] = 			"template/";
$c_node['dir']['class_path'] = 				"class/";


// LOG CONFIGURATION -----------------------------------------------------.
// set to true to write to log file / false not to.
$c_node['log'] = 							false;


// LANGUAGE CONFIGURATION ------------------------------------------------
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$c_node['node']['language']['default'] = 	"1"; //default language
// UK (real) English /aspell lang
$c_node['node']['language']['pack'][1] = 	array('eng', 'en');


// MAIL CONFIGURATION ----- ----------------------------------------------
// phpMailer. See http://phpmailer.sourceforge.net/ for settings.
$c_node['mail']['host'] = 					"your_mail_server.com";
$c_node['mail']['no_reply_address'] = 		"nopreply@your_mail.org";
$c_node['mail']['default_address'] = 		"you@your_mail.org";
$c_node['mail']['mailer'] = 				"smtp";
$c_node['mail']['from_name'] = 				"company_name";
$c_node['mail']['wordwrap'] = 				"80";
// This is the language for error messages which are not written to screen, so 
// it's not worth changing adjusting this
$c_node['mail']['language'] = 				"en";
//if you need a username and password to access SMTP then uncomment these 
// and add your username and password
//$c_node['mail']['smtp']['username'] = 	"your_username";
//$c_node['mail']['smtp']['password'] = 	"your_password";


// DICTIONARY ----------------------------------------------
// if Aspell is installed you can configure aroundme to show a spellchecker button
// standard aspell installs are either:
// WINDOWS -> '"C:\Program Files\Aspell\bin\aspell.exe"'(use the double quotes inside the single quotes)
// GNU/Linux -> "/usr/local/bin/aspell"
// Leave the command blank "" to tell aroundme NOT TO show shellchecker
$c_node['node']['aspell']['command'] = 	'';


// SECURITY --------------------------------------------------------------
// 1 to allow, anything else to deny
$c_node['access']['allow_registration'] = 					1;
$c_node['access']['allow_anonymous_comment'] = 				0;


// USER ------------------------------------------------------------------
$c_node['permission']['edit_user'] = 						1;
$c_node['permission']['edit_file'] = 						2;
$c_node['permission']['edit_item'] = 						3;
$c_node['permission']['edit_menu'] = 						4;
$c_node['permission']['edit_category'] = 					5;
$c_node['permission']['send_newsletter'] = 					6;

$c_node['user_status']['pending'] = 						1;
$c_node['user_status']['barred'] = 							1;
$c_node['user_status']['live'] = 							3;


// FILE CONFIGURATION ----------------------------------------------------
$c_node['file']['asset_path'] = 							"asset/";


// MIME CONFIGURATION ----------------------------------------------------
//full list at http://www.phpfreaks.com/mimetypes.php
//make sure you think about the implications for viruses before editing this
//edit the functions.inc.php formatFileOuptput functions to create correct html output
$c_node['file']['mime'][1]['mime'] = 						"image/jpeg";
$c_node['file']['mime'][1]['suffix'] = 						"jpg";
$c_node['file']['mime'][2]['mime'] = 						"image/png";
$c_node['file']['mime'][2]['suffix'] = 						"png";
$c_node['file']['mime'][3]['mime'] = 						"image/gif";
$c_node['file']['mime'][3]['suffix'] = 						"gif";
$c_node['file']['mime'][4]['mime'] = 						"application/pdf";
$c_node['file']['mime'][4]['suffix'] = 						"pdf";
$c_node['file']['mime'][5]['mime'] = 						"text/plain";
$c_node['file']['mime'][5]['suffix'] = 						"txt";
//image and thumbs
$c_node['file']['image']['max_width'] = 					"520"; //main image
$c_node['file']['image']['thumb_directory'] = 				"thumbs/";
$c_node['file']['image']['thumb'][1]['name'] =				"t1";
$c_node['file']['image']['thumb'][1]['noimage'] =			"no_file_t.png";
$c_node['file']['image']['thumb'][1]['width'] =				"60";
//name of "broken image" image is displayed if the file cannot be found
$c_node['file']['image']['broken_image'] =					"broken_image.png";
//sometimes MIME types vary from browser to browser - this array will convert
//other MIME types to those listed above
// add an array for each instance of the MIME types you want changing
$c_node['file']['mime']['browser_path'] =					array(array("from" => "image/pjpeg", "to" => "image/jpeg"));


// MENU CONFIGURATION ----------------------------------------------------
$c_node['menu']['menu'][1] = 								1; //side menu
$c_node['menu']['menu'][2] = 								2; //base menu
$c_node['menu']['link_type']['wikipage'] = 					1; //wikipage
$c_node['menu']['link_type']['category'] = 					2; //category
$c_node['menu']['link_type']['external_link'] = 			3; //external link


//CRON CONFIGURATION -----------------------------------------------------
// set bulk_email to "1" if you wish to use cron
$c_node['cron']['bulk_email'] = 							"0";


//NEWSLETTER CONFIGURATION ------------------------------------------------
$c_node['newsletter']['nr_per_batch'] = 					"10";


// END OF CONFIGURATION FILE ---------------------------------------------
?>
