<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


class Item {
	// CLASS FUNCTIONS
	// Item
	// selItem
	// insertItem
	// selItemsFromWiki
	// selItems
	// deleteItem
	// selPages
	// selCategories
	// selCategory
	// updateCategory
	// insertCategory
	// selWikiPageNames



	// Item -------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th June 2005
	//
	function Item($db, $date) {
		$this->db = $db;
		$this->date = $date;
	}//EO Item



	// selItem ----------------------------------------------------------
	//
	// We either get the item by item_id, get the item by the wiki page 
	// name, get the newest item by category or get the default page.
	// tom calthrop - 6th June 2005
	//
	function selItem() {
		
		$query = "
			SELECT i.item_id, i.item_title, i.item_synopsis, 
			i.item_create_datetime, i.item_body, 
			w.wiki_page, w.wiki_id, w.current_item_id, 
			i.language_id, i.category_id, i.allow_comment, 
			i.beacon_default_page, i.item_note, i.status_id 
			FROM " . $this->db->prefix . "_item i,  " . $this->db->prefix . "_wiki w 
			WHERE 
			w.wiki_id = i.wiki_id AND "
		;
		
		if (isset($this->item_id)) {
		    $query .= "i.item_id='" . $this->item_id . "' AND ";
		}
		elseif (isset($this->item_wiki_page)) {
			$query .= "w.current_item_id = i.item_id AND w.wiki_page=" . $this->db->qstr($this->item_wiki_page, get_magic_quotes_gpc()) . " AND ";
		}
		elseif (isset($this->category_id)) {
			$query .= "w.current_item_id = i.item_id AND i.category_id=" . $this->category_id . " AND ";
		}
		else {
		    $query .= "w.current_item_id = i.item_id AND i.beacon_default_page=1 AND ";
		}
		
		if (isset($this->language_id)) {
		    $query .= "i.language_id=" . $this->language_id . " AND ";
		}
		
		
		$query .= "1=1 order by i.item_create_datetime desc";
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields)) {

			$temp = $result->fields;
			$this->item_id = $temp['item_id'];

			if (!empty($temp['item_create_datetime'])) {
				$temp['item_create_datetime'] = $this->date->formatDate($temp['item_create_datetime'], 1);
			}
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selItem



	// insertItem --------------------------------------------------------------------
	// inserts a single item in the item table
	// updates or adds an item to the wiki table
	// tom calthrop - 22nd May 2004
	//
	function insertItem($data) {
		
		if(empty($data['item_title'])) {
			$GLOBALS['beacon_error_log'][] = array(3, null);
		}
		
		if(empty($data['wiki_id'])) {
			if ($this->_checkWikiPage($data['wiki_page'])) {
				$data['wiki_id'] = $this->_insertWikiPage($data['wiki_page']);
			}
			else {
				$GLOBALS['beacon_error_log'][] = array(11, null);
			}
		}
		
		if(empty($data['item_body'])) {
			$GLOBALS['beacon_error_log'][] = array(10, null);
		}

		if (empty($GLOBALS['beacon_error_log'])) {
			
			if(empty($data['category_id'])) {
				$data['category_id'] = "null";
			}
			
			if(!empty($data['beacon_default_page'])) {
				$data['beacon_default_page'] = 1;
			}
			else {
				$data['beacon_default_page'] = "null";
			}
			
			if(!empty($data['allow_comment'])) {
				$data['allow_comment'] = 1;
			}
			else {
				$data['allow_comment'] = "null";
			}
			
			if(empty($data['wiki_id'])) {
				$data['wiki_id'] = "null";
			}
			
			if(empty($data['status_id'])) {
				$data['status_id'] = "null";
			}
			
			$rec = array();
			$rec['item_title'] = $data['item_title'];
			$rec['item_synopsis'] = $data['item_synopsis'];
			$rec['item_body'] = $data['item_body'];
			$rec['item_note'] = $data['item_note'];
			$rec['item_create_datetime'] = time();
			$rec['wiki_id'] = $data['wiki_id'];
			$rec['language_id'] = $data['language_id'];
			$rec['category_id'] = $data['category_id'];
			$rec['beacon_default_page'] = round($data['beacon_default_page']);
			$rec['allow_comment'] = round($data['allow_comment']);
			$rec['status_id'] = round($data['status_id']);
			
			$table = $this->db->prefix . "_item";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->item_id = $this->db->Insert_ID();
				
				// We update the WIKI table
				$query = "
					SELECT * FROM " . $this->db->prefix . "_wiki
					WHERE 
					wiki_id=" . $data['wiki_id']
				;
				
				$result = $this->db->Execute($query);
				
				$this->wiki_page = $result->fields['wiki_page'];
				
				$rec = array();
				$rec['current_item_id'] = $this->item_id;
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
				if (!isset($result)) {
					$error_info = "function=insertItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['beacon_error_log'][] = array(1, $error_info);
				}
			}
			else {
				$error_info = "function=insertItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
	} //EO insertItem
	
	
	
	// _checkWikiPage -------------------------------------------------------
	// returns true if wiki page name ok to use
	// tom calthrop - 22nd May 2004
	//
	function _checkWikiPage($wiki_page) {
		// Check the format of the name
		if (strlen($wiki_page) < 5) { // enough characters?
			$GLOBALS['beacon_error_log'][] = array(9, null);
		}
		/*
		$compare = strtoupper($wiki_page);
		$uppervals = strcmp($wiki_page, $compare);
		if ($uppervals < 2) { // not enough upp case values
			$GLOBALS['beacon_error_log'][] = array(9, $uppervals);
		}
		*/
		if (empty($GLOBALS['beacon_error_log'])) {
			
			$wiki_page = $this->db->qstr($wiki_page, get_magic_quotes_gpc());
			
			$query = "
				SELECT wiki_id 
				DFROM " . $this->db->prefix . "_wiki 
				WHERE
				wiki_page=" . $wiki_page
			;
			
			$result = $this->db->SelectLimit($query, 1);

			if (!isset($result->fields['item_id'])) { //page name is unique
				return true;
			}
		}
		
		
	} //EO _checkWikiPage
	
	
	
	// _insertWikiPage --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// if full is set we select all wikipages else we select only the current
	// tom calthrop - 22nd May 2004
	//
	function _insertWikiPage($wiki_page) {
		
		$rec = array();
		$rec['wiki_page'] = $wiki_page;
		
		$table = $this->db->prefix . "_wiki";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
				
		if (isset($result)) {
			return $this->db->Insert_ID();
		}
		else {
			$error_info = "function=_insertWikiPage class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
		
	} //EO _insertWikiPage
	
	
	
	// selItems --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// if full is set we select all wikipages else we select only the current
	// tom calthrop - 22nd May 2004
	//
	function selItems($full=null, $search=null) {
		$query = "
			SELECT i.item_id, i.item_title, i.item_synopsis, 
			i.item_create_datetime, i.item_body, 
			w.wiki_page, w.wiki_id, 
			i.language_id, i.category_id, i.allow_comment, 
			i.beacon_default_page 
			FROM " . $this->db->prefix . "_item i,  " . $this->db->prefix . "_wiki w 
			WHERE 
			w.wiki_id = i.wiki_id AND "
		;
		
		if (!isset($full)) {
		    $query .= "w.current_item_id = i.item_id AND ";
		}
		
		if (isset($this->item_wiki_page)) {
			$query .= "w.wiki_page=" . $this->db->qstr($this->item_wiki_page, get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->category_id)) {
			$query .= "i.category_id=" . $this->category_id . " AND ";
		}
		
		if (isset($this->language_id)) {
		    $query .= "i.language_id=" . $this->language_id . " AND ";
		}
		
		if (isset($this->status_id)) {
		    $query .= "i.status_id=" . $this->status_id . " AND ";
		}
		
		if (isset($search)) {
			$searchStr = "%". $search . "%";
			
			$query .= "(
				i.item_title like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . " OR 
				i.item_synopsis like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . " OR 
				i.item_body like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by i.item_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['item_create_datetime'] = $this->date->formatDate($temp1['item_create_datetime'], 1);
				
				//format search results
				if (isset($search)) {
					$temp1['item_synopsis'] = searchTextFormat($search, $temp1['item_synopsis']);
					$temp1['item_title'] = searchTextFormat($search, $temp1['item_title']);
					$temp1['item_body'] = searchTextFormat($search, $temp1['item_body']);
				}
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=selItems class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selItems()



	// deleteItem --------------------------------------------------------------------
	// delete item from DB
	// tom calthrop - 22nd May 2004
	//
	function deleteItems($del_id) {
		$query = "
			DELETE from " . $this->db->prefix . "_item
			WHERE
			item_id = " . $del_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$GLOBALS['beacon_error_log'][] = array(1, $query . "-" . $this->db->ErrorMsg());
		}
	}//EO deleteItem
	
	
	
	// selCategories --------------------------------------------------------------------
	// returns the categories
	// tom calthrop - 29th May 2005
	//
	function selCategories() {

		$query = "
			SELECT c.category_id, c.category_name, parent_id 
			FROM " . $this->db->prefix . "_category c 
			WHERE "
		;
		
		if (isset($this->language_id)) {
		    $query .= "c.language_id=" . $this->language_id . " AND ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by c.parent_id";
		}
		
		//echo $query . "<br>";
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
			
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} //EO selCategories
	
	
	
	// selCategory --------------------------------------------------------------------
	// returns the category
	// tom calthrop - 29th May 2005
	//
	function selCategory($category_id) {

		$query = "
			SELECT c.category_id, c.category_name, parent_id 
			FROM " . $this->db->prefix . "_category c 
			WHERE 
			category_id=" . $category_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = $result->fields;
			$result->Close();
			return $temp;
			
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} //EO selCategory
	
	
	
	// updateCategory --------------------------------------------------------------------
	// updates a category
	// tom calthrop - 29th May 2005
	//
	function updateCategory($data) {
		$query = "
			SELECT * FROM " . $this->db->prefix . "_category
			WHERE category_id = " . $data['category_id']
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['category_name'] = $data['category_name'];
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=updateCategory class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	
	} //EO updateCategory();
	
	
	
	// insertCategory --------------------------------------------------------------------
	// inserts a category
	// tom calthrop - 29th May 2005
	//
	function insertCategory($data) {
	
		if (empty($data['parent_id'])) {
		    $data['parent_id'] = 0;
		}
		
		$rec = array();
		$rec['category_name'] = $data['category_name'];
		$rec['parent_id'] = $data['parent_id'];
		$rec['language_id'] = $this->language_id;
		$rec['user_id'] = $this->user_id;
		
		$table = $this->db->prefix . "_category";
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=insertCategory class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, $error_info);
		}
	
	} //EO insertCategory();
	
	
	
	// selWikiPageNames --------------------------------------------------------------------
	// returns multiple rows of selWikiPageNames from DB
	// tom calthrop - 27th May 2004
	//
	function selWikiPageNames($incID=null) {
		$query = "
			SELECT wiki_page, wiki_id 
			FROM " . $this->db->prefix . "_wiki 
			ORDER BY wiki_page"
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				if (isset($incID)) {
				$temp1 = $result->fields;
				} 
				else {
					$temp1 = $result->fields['wiki_page'];
				}
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} // EO selWikiPageNames
}

?>
