#!/bin/sh
#
# updatestatus.sh
#
# Update the status table

# Eric Chassande-Mottin

# $Id: updatestatus.sh,v 1.1 2008/09/09 16:33:23 ecm Exp $

# check if status is empty
if [ ! -s status ]; then
    echo "status table is empty"
    exit 2
fi

tag=$(grep "$#" status | awk '{print $2}')

# check if submitted jobs are still in the queue
grep -n submitted$ status |
while read line
do
    lineNumber=`echo ${line} | cut -d: -f1`
    analysisNumber=`echo "${line}" | awk '{print $2}'`
    jobs=`qjob -l | awk '{print $2}' | grep ^$tag.*$analysisNumber$ | tail -1`
    if [ -z "$jobs" ]; then
	cat status | sed -e "${lineNumber}s/$/ finished" > status
    fi
done 

# return exit status
exit $?
