#!/bin/sh
#
# reset.sh [run]
#
# Script to reset an analysis

# Shourov K. Chatterji
# shourov@ligo.caltech.edu

# Eric Chassande-Mottin
# adapt to qsub queues

# $Id: reset.sh,v 1.1 2008/09/09 16:33:22 ecm Exp $

# parse command line arguments
if [ $# -ge 1 ]; then
    runNumber=`printf "%02d" $1`
else
    runNumber=0
fi

# request confirmation
echo " "
echo "WARNING: All results, logs, etc. associated with this"
echo "run directory will be irretrievably removed."
echo " "
echo -n "Are you sure you want to continue [yes/no]? "
read response
if [ "x${response}" != "xyes" ]; then
  echo " "
  echo "The run directory has not been reset."
  exit 1
fi

# remove result and logs files and directory
if [ -d ${runNumber} ]; then
    rm -rf ${runNumber}

    # update status table
    cat status | grep -v "^.. ${runNumber}" > status

    # return to calling function
    exit 0
else
    echo "The run directory was not found"
fi

