#!/bin/sh
#
# reanalyse.sh [run]
#
# Generate submission script with jobs that terminated prematurely

# Eric Chassande-Mottin

# $Id: reanalyze.sh,v 1.1 2008/09/09 16:33:22 ecm Exp $

# determine run number
if [ $# -gt 0 ]; then
    runNumber=$1
else
    runNumber=0
fi

# check if run directory exists
if [ ! -d "${runNumber}" ]; then
    printf "directory not found for run %d" $runNumber
    exit 2
fi

# get list of killed segments
segments=`grep -H KILL $runNumber/log/stdout/* | awk '{print $1}' | sed -e"s/stdout_//" -e "s/.txt:\*//"`
numberOfSegments=`echo $segments | wc -l`

# if no segment were killed, exit successfully
if [ -z $segments ]; then
    exit 0
fi

# check if status table is empty
if [ ! -s status ]; then
    echo "status table is empty"
    exit 2
fi

# determine analysis number from the status table
lastAnalysisNumber=`sort status | grep "^.. $runNumber" | tail -1 | awk '{print $1}'`
analysisNumber=`printf "%02d" $((lastAnalysisNumber+1))`
submissionFile=analysis$analysisNumber.batch

# report 
printf "%d jobs were killed\n" $numberOfSegments
printf "Generate new submission file %s" $submissionFile

# generate submission file
touch $submissionFile
for segment in `echo $segments`
do
    cat analysis*.batch | grep $segment >> $submissionFile
done

# append this analysis to status table
echo "$analysisNumber $runNumber" >> status