#!/usr/bin/env octave-q

## Copyright (C) 2008 Eric Chassande-Mottin, CNRS (France)

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see .

if nargchk(2,2,nargin)
    usage("randselect_segments.sh file.txt nsegments");
endif

args=argv();

filename=args{1};
if ~exist(filename,"file")
  error("file not found");
endif

eval(sprintf("data=load %s;",filename));;

N=rows(data);

nsegments=str2num(args{2});

if (nsegments==0)
 return
endif

if ((nsegments<0)|(nsegments > N))
  error("invalid number of segments");
endif

idx=randperm(N);
idx=sort(idx(1:nsegments));

printf("#Selection of %d segments from %s\n",nsegments,filename);
printf("#Generated using randselect_segments by %s, %s\n",getenv("USER"),date);

for n=1:nsegments,
  printf("%d %d %d %d\n",data(idx(n),1),data(idx(n),2),data(idx(n),3),data(idx(n),4));
endfor
