#!/usr/bin/env octave-q

## Copyright (C) 2008 Eric Chassande-Mottin, CNRS (France)

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see .

if nargchk(2,2,nargin)
    usage("and_segments.sh file1.txt file2.txt");
endif

args=argv();

filename1=args{1};
if ~exist(filename1,"file")
  error("file1 not found");
endif

eval(sprintf("data1=load %s;",filename1));;

timestart1=data1(:,2);
timestop1=data1(:,3);

filename2=args{2};
if ~exist(filename2,"file")
  error("file2 not found");
endif

eval(sprintf("data2=load %s;",filename2));;

timestart2=data2(:,2);
timestop2=data2(:,3);

printf("#Combine segments from %s and %s\n",filename1,filename2);
printf("#Generated using and_segments by %s, %s\n",getenv("USER"),date);

for n=1:rows(data1) 
 idx=max(find(timestart2<=timestart1(n))); 
 if (timestop1(n)<=timestop2(idx))
   printf("%d %d %d %d\n",data1(n,1),data1(n,2),data1(n,3),data1(n,4));
 endif
endfor
