## tests for proj_dist.m

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: proj_distt.m,v 1.1 2008/09/05 14:55:42 ecm Exp $

clear;

X=create_detector("X","ITF","X",0.0,0.0,[0.0 0.0],1.0);
X.radius=1.0;
Y=create_detector("Y","ITF","Y",pi ,0.0,[0.0 0.0],1.0);
Y.radius=1.0;

det=[X Y];

printf("test1: 2 coincident detectors\n");

d=proj_dist(det,[0.0 pi/2 pi 3*pi/2],[0.0 0.0 0.0 0.0]);

if (any(vec(abs(d))>eps))
  error("test1 failed\n");
else
  printf("test1 passed\n");
end;

printf("test2: 2 detectors aligned with the source direction\n");

d=proj_dist(det,[0.0 pi],[pi/2 pi/2]);

ref=[+2 -2];

if (any(squeeze(d)-ref)>eps)
  error("test2 failed\n");
else
  printf("test2 passed\n");
end;

X=create_detector("X","ITF","X",0.0,0.0,[0.0 0.0],1.0);
X.radius=1.0;
Y=create_detector("Y","ITF","Y",pi/2,0.0,[0.0 0.0],1.0);
Y.radius=1.0;
Z=create_detector("Z","ITF","Z",0.0,pi/2,[0.0 0.0],1.0);
Z.radius=1.0;

det=[X Y Z];

printf("test3: 3 coincident detectors\n");

alpha=atan(sqrt(2));

d=proj_dist(det,[pi/4 5*pi/4],[alpha pi-alpha]);

if (any(abs(vec(d))>eps))
  error("test3 failed\n");
else
  printf("test3 passed\n");
end;

printf("test4: source direction grid with 3 detectors\n");

phi_v=[-pi/2 0 pi/2];
theta_v=[0 pi/4 pi/2];
[phi,theta]=meshgrid(phi_v,theta_v);
d=proj_dist(det,phi,theta);

r=sqrt(2)/2;
ref=zeros([size(phi) length(det)-1]);
ref(:,:,1)=[[0.0 0.0 0.0];[r r -r];[1 1 -1]];
ref(:,:,2)=[[-1 -1 -1];[-r 0 -r];[0 1 0]];

if (any(vec(ref-d)>eps))
  error("test4 failed\n");
else
  printf("test4 passed\n");
end;
